/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import java.io.Serializable;
import java.util.Iterator;
import javax.annotation.Nullable;

/**
 *  An ordering which sorts iterables by comparing corresponding elements
 *  pairwise.
 *
 * @deprecated The Google Guava Core Libraries are deprecated and will not be part of the AEM SDK after April 2023
 */
@GwtCompatible(serializable = true)
@Deprecated(since = "2022-12-01")
final class LexicographicalOrdering<T> extends Ordering<Iterable<T>> implements Serializable {

    final Ordering<? super T> elementOrder;

    LexicographicalOrdering(Ordering<? super T> elementOrder) {
        this.elementOrder = elementOrder;
    }

    @Override
    public int compare(Iterable<T> leftIterable, Iterable<T> rightIterable) {
        Iterator<T> left = leftIterable.iterator();
        Iterator<T> right = rightIterable.iterator();
        while (left.hasNext()) {
            if (!right.hasNext()) {
                // because it's longer
                return LEFT_IS_GREATER;
            }
            int result = elementOrder.compare(left.next(), right.next());
            if (result != 0) {
                return result;
            }
        }
        if (right.hasNext()) {
            // because it's longer
            return RIGHT_IS_GREATER;
        }
        return 0;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LexicographicalOrdering) {
            LexicographicalOrdering<?> that = (LexicographicalOrdering<?>) object;
            return this.elementOrder.equals(that.elementOrder);
        }
        return false;
    }

    @Override
    public int hashCode() {
        // meaningless
        return elementOrder.hashCode() ^ 2075626741;
    }

    @Override
    public String toString() {
        return elementOrder + ".lexicographical()";
    }

    private static final long serialVersionUID = 0;
}
