/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2017 Adobe Systems Incorporated
 * All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 */

package com.adobe.cq.dam.cfm;

/**
 * Defines the type string (see {@link DataType#getTypeString()} for the required data
 * types.
 *
 * <p>Note that an implementation may provide additional data types on top.</p>
 *
 * @since 1.1
 */
public final class BasicDataType {

    private BasicDataType() {
        // prevent instantiation
    }

    /**
     * Data type: {@code Boolean} value
     */
    public static final String BOOLEAN = "boolean";

    /**
     * Data type: {@code Long} value
     */
    public static final String LONG = "long";

    /**
     * Data type: {@code Double} value
     */
    public static final String DOUBLE = "double";

    /**
     * Data type: {@code String} value
     */
    public static final String STRING = "string";

    /**
     * Data type: {@code Calendar} value
     */
    public static final String CALENDAR = "calendar";

    /**
     * Data type: {@code ContentFragment} value
     *
     * @deprecated Use {@link SemanticDataType#CONTENT_FRAGMENT} instead
     */
    @Deprecated
    public static final String CONTENT_FRAGMENT = "content-fragment";

    /**
     * Data type: {@code Json} value
     *
     * @since : 1.6.0
     * @deprecated Use {@link SemanticDataType#JSON} instead
     */
    @Deprecated
    public static final String JSON = "json";
}
