/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */

package com.day.cq.commons.predicate;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import com.day.cq.commons.predicates.NodePredicate;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Predicate used to filter jcr nodes.
 * @deprecated use  {@link NodePredicate} instead
 */
@Deprecated
abstract public class AbstractNodePredicate implements Predicate {

    /**
     * default logger
     */
    private final Logger log = LoggerFactory.getLogger(AbstractNodePredicate.class);

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if o is a JCR Node or a Resource that can be
     * adapted to a JCR Node and the subsequent call to {@link #evaluate(Node)}
     * returns <code>true</code>; <code>false</code> otherwise.
     * @deprecated
     */
    @Deprecated
    public boolean evaluate(Object o) {
        log.warn("AbstractNodePredicate has been deprecated. Please use com.day.cq.commons.predicates.NodePredicate instead.");
        Node n = null;
        if (o instanceof Resource) {
            n = ((Resource) o).adaptTo(Node.class);
        } else if (o instanceof Node) {
            n = (Node) o;
        }
        if (n != null) {
            try {
                return evaluate(n);
            } catch (RepositoryException e) {
                log.warn("RepositoryException in evaluate()", e);
            }
        }
        return false;
    }

    /**
     * Evaluates this predicate on the given node.
     *
     * @param node the node
     * @return <code>true</code> if this node satisfies this predicate
     * @throws RepositoryException if an error during evaluation occurs
     * @deprecated
     */
    @Deprecated
    abstract public boolean evaluate(Node node) throws RepositoryException;
}