/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 * 
 * Copyright 2024 Adobe
 * All Rights Reserved.
 * 
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.commons.predicates;

import com.day.cq.commons.jcr.JcrConstants;
import java.util.function.Predicate;

import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

/**
 * Predicate used to filter Hierarchy nodes BUT not nt:file nodes.
 */
@Component(
        service = Predicate.class,
        property = {
                "service.vendor=Adobe Systems Incorporated",
                "predicate.name=hierarchyNotFile"
        })
public class HierarchyNotFilePredicate implements NodePredicate {

    /**
     * default logger
     */
    private final Logger log = LoggerFactory.getLogger(HierarchyNotFilePredicate.class);

    /**
     * {@inheritDoc}
     *
     * @return <code>true</code> if node is nt:hierarchyNode but not nt:file
     */
    @Override
    public boolean test(Node node) {
        try {
            return node.isNodeType(JcrConstants.NT_HIERARCHYNODE) && !node.isNodeType(JcrConstants.NT_FILE);
        } catch (RepositoryException e) {
            log.warn("RepositoryException in evaluate()", e);
        }
        return false;
    }
}

