/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.replication;

/**
 * The <code>Location</code> can be used to convey information about a repository path.
 */
public class Location {

    /**
     * Path of the location to replicate.
     */
    private final String path;

    /**
     * Revision version of the location to replicate.
     */
    private final String revision;

    /**
     * Creates an instance of the Location class.
     * @param path See {@link #getPath()}
     * @param revision See {@link #getRevision()}
     */
    public Location(String path, String revision) {
        this.path = path;
        this.revision = revision;
    }

    /**
     * Returns the file system path of the location to replicate.
     * @return the path of the location.
     */
    public String getPath() {
        return path;
    }

    /**
     * Returns the revision to replicate.
     * @return location replication revision.
     */
    public String getRevision() {
        return revision;
    }
}