/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.workflow.event;

import java.util.Dictionary;
import java.util.Map;

import org.osgi.service.event.Event;

import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.model.WorkflowModel;
import com.day.cq.workflow.model.WorkflowNode;

/**
 * <code>WorkflowEvent</code> provides an extension of {@link Event} that is
 * used for propagating workflow related information as OSGI events.
 */
public class WorkflowEvent extends Event {
	/** The job topic for adding an entry to the audit log. */
	public static final String EVENT_TOPIC = "com/day/cq/workflow/event";

	/** Time stamp of the time the event was created. */
	public static final String TIME_STAMP = "TimeStamp";

	/** The user whose that has triggered the event. */
	public static final String USER = "User";

	/** The name of the {@link WorkflowModel} the event relates to. */
	public static final String WORKFLOW_NAME = "WorkflowName";

	/** The version of the {@link WorkflowModel} the event relates to. */
	public static final String WORKFLOW_VERSION = "WorkflowVersion";

	/** The node of the {@link WorkflowModel} the event relates to. */
	public static final String WORKFLOW_NODE = "WorkflowNode";

	/** The ID of the {@link Workflow} instance the event relates to. */
	public static final String WORKFLOW_INSTANCE_ID = "WorkflowInstanceId";

	/**
	 * ID of the parent {@link Workflow} of the {@link Workflow} instance the
	 * event relates to.
	 */
	public static final String PARENT_WORKFLOW_ID = "ParentWorkflowId";

	/** The {@link WorkflowData} that relates to the event. */
	public static final String WORK_DATA = "Workdata";

	/** The {@link WorkItem} that relates to the event. */
	public static final String WORK_ITEM = "Workitem";

	/**
	 * The {@link WorkflowNode} that is the source of a
	 * {@link #NODE_TRANSITION_EVENT}.
	 */
	public static final String FROM_NODE_NAME = "fromNodeName";

	/**
	 * The {@link WorkflowNode} that is the target of a
	 * {@link #NODE_TRANSITION_EVENT}.
	 */
	public static final String TO_NODE_NAME = "toNodeName";

	/**
	 * The name of the variable that has changed when a
	 * {@link #VARIABLE_UPDATE_EVENT} is triggered.
	 */
	public static final String VARIABLE_NAME = "VariableName";

	/**
	 * The new value of the variable that has changed when a
	 * {@link #VARIABLE_UPDATE_EVENT} is triggered.
	 */
	public static final String VARIABLE_VALUE = "VariableValue";

    /**
     * Delegate name
     */
    public static final String DELEGATEE = "Delagatee";

    // ---- Event types --------------------------------------------------------

	/**
	 * The type of the event. Can be one of
	 *
	 * <ul>
	 * <li>{@link #MODEL_DEPLOYED_EVENT}</li>
	 * <li>{@link #WORKFLOW_STARTED_EVENT}</li>
	 * <li>{@link #WORKFLOW_ABORTED_EVENT}</li>
	 * <li>{@link #WORKFLOW_SUSPENDED_EVENT}</li>
	 * <li>{@link #WORKFLOW_RESUMED_EVENT}</li>
	 * <li>{@link #WORKFLOW_COMPLETED_EVENT}</li>
	 * <li>{@link #NODE_TRANSITION_EVENT}</li>
	 * <li>{@link #VARIABLE_UPDATE_EVENT}</li>
	 * <li>{@link #PROCESS_TIMEOUT_EVENT}</li>
     * <li>{@link #WORKITEM_DELEGATION_EVENT}</li>
	 * </ul>
	 */
	public static final String EVENT_TYPE = "EventType";

	public static final String MODEL_DEPLOYED_EVENT = "ModelDeployed";
	public static final String MODEL_DELETED_EVENT = "ModelDeleted";
	public static final String WORKFLOW_STARTED_EVENT = "WorkflowStarted";
	public static final String WORKFLOW_ABORTED_EVENT = "WorkflowAborted";
	public static final String WORKFLOW_SUSPENDED_EVENT = "WorkflowSuspended";
	public static final String WORKFLOW_RESUMED_EVENT = "WorkflowResumed";
	public static final String WORKFLOW_COMPLETED_EVENT = "WorkflowCompleted";
	public static final String NODE_TRANSITION_EVENT = "NodeTransition";
	public static final String VARIABLE_UPDATE_EVENT = "VariableUpdate";
	public static final String PROCESS_TIMEOUT_EVENT = "ProcessTimeout";
    public static final String WORKITEM_DELEGATION_EVENT = "WorkItemDelegated";
    public static final String JOB_FAILED_EVENT = "JobFailed";
    public static final String RESOURCE_COLLECTION_MODIFIED = "ResourceCollectionModified";

    /**
	 * Default constructor used for creating <code>WorkflowEvent</code>
	 * instances.
	 *
	 * @param props
	 *            The properties assigned to the event.
	 */
	@SuppressWarnings("unchecked")
    public WorkflowEvent(Dictionary<?, ?> props) {
		super(EVENT_TOPIC, (Map<String, ?>) props);
	}
}
