/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  The ASF licenses this file to You
 * under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.  For additional information regarding
 * copyright in this work, please see the NOTICE file in the top level
 * directory of this distribution.
 */
package org.apache.abdera.util;

import org.apache.abdera.Abdera;
import org.apache.abdera.parser.NamedParser;

/**
 *  Base abstract implementation of NamedParser
 *
 * @deprecated This API is deprecated as Apache Abdera is a retired project since 2017.
 */
@Deprecated(since = "2021-07-29")
public abstract class AbstractNamedParser extends AbstractParser implements NamedParser {

    protected final String name;

    protected final String[] formats;

    protected AbstractNamedParser(Abdera abdera, String name, String... formats) {
        super(abdera);
        this.name = name;
        this.formats = formats;
    }

    public String getName() {
        return name;
    }

    public String[] getInputFormats() {
        return formats;
    }

    public boolean parsesFormat(String mediatype) {
        for (String format : formats) {
            if (MimeTypeHelper.isMatch(format, mediatype))
                return true;
        }
        return false;
    }
}
