/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.Matrix;

public final class Rect {
    public final double xmin;
    public final double ymin;
    public final double xmax;
    public final double ymax;
    public static final Rect emptyRect = new Rect(0.0, 0.0, 0.0, 0.0);

    public Rect(double xmin, double ymin, double xmax, double ymax) {
        this.xmin = xmin;
        this.ymin = ymin;
        this.xmax = xmax;
        this.ymax = ymax;
    }

    public Rect(double[] vals) {
        this.xmin = vals[0];
        this.ymin = vals[1];
        this.xmax = vals[2];
        this.ymax = vals[3];
    }

    public Rect applyMatrix(Matrix m) {
        if (m.isIdentity()) {
            return this;
        }
        double tlX = m.applyToXYGetX(this.xmin, this.ymax);
        double tlY = m.applyToXYGetY(this.xmin, this.ymax);
        double trX = m.applyToXYGetX(this.xmax, this.ymax);
        double trY = m.applyToXYGetY(this.xmax, this.ymax);
        double brX = m.applyToXYGetX(this.xmax, this.ymin);
        double brY = m.applyToXYGetY(this.xmax, this.ymin);
        double blX = m.applyToXYGetX(this.xmin, this.ymin);
        double blY = m.applyToXYGetY(this.xmin, this.ymin);
        return new Rect(Math.min(Math.min(tlX, trX), Math.min(brX, blX)), Math.min(Math.min(tlY, trY), Math.min(brY, blY)), Math.max(Math.max(tlX, trX), Math.max(brX, blX)), Math.max(Math.max(tlY, trY), Math.max(brY, blY)));
    }

    public Rect toEmSpace(double unitsPerEmX, double unitsPerEmY) {
        return new Rect(this.xmin / unitsPerEmX, this.ymin / unitsPerEmY, this.xmax / unitsPerEmX, this.ymax / unitsPerEmY);
    }

    public Rect toDesignSpace(double unitsPerEmX, double unitsPerEmY) {
        return new Rect(this.xmin * unitsPerEmX, this.ymin * unitsPerEmY, this.xmax * unitsPerEmX, this.ymax * unitsPerEmY);
    }

    public String toString() {
        return "[ " + Double.toString(this.xmin) + " " + Double.toString(this.ymin) + " " + Double.toString(this.xmax) + " " + Double.toString(this.ymax) + " ]";
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Rect) {
                Rect r = (Rect)obj;
                return Double.compare(this.xmin, r.xmin) == 0 && Double.compare(this.ymin, r.ymin) == 0 && Double.compare(this.xmax, r.xmax) == 0 && Double.compare(this.ymax, r.ymax) == 0;
            }
        }
        return false;
    }

    public int hashCode() {
        return (int)this.xmin ^ (int)this.xmax ^ (int)this.ymin ^ (int)this.ymax;
    }
}

