/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.i18n;

import com.adobe.granite.toggle.api.ToggleRouter;
import java.util.IllformedLocaleException;
import java.util.Locale;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public abstract class LocaleUtil {
    private static ToggleRouter toggleRouter;

    public static Locale parseLocale(String text) {
        String[] elements = text.split("-|_");
        if (toggleRouter != null && !toggleRouter.isEnabled("FT_CQ-4332753")) {
            if (elements.length == 1) {
                return new Locale(elements[0]);
            }
            if (elements.length == 2) {
                return new Locale(elements[0], elements[1]);
            }
            if (elements.length >= 3) {
                return new Locale(elements[0], elements[1], elements[2]);
            }
            throw new IllegalArgumentException("Unparsable text: " + text);
        }
        if (elements.length == 0) {
            throw new IllegalArgumentException("Unparsable text: " + text);
        }
        if (elements.length == 1) {
            return new Locale(elements[0]);
        }
        Locale localeWithBuilder = LocaleUtil.createLocaleWithBuilder(elements);
        if (localeWithBuilder != null) {
            return localeWithBuilder;
        }
        return LocaleUtil.createLocaleWithConstructor(elements);
    }

    private static Locale createLocaleWithBuilder(String[] parts) {
        if (LocaleUtil.isScript(parts[1])) {
            try {
                switch (parts.length) {
                    case 2: {
                        return new Locale.Builder().setLanguage(parts[0]).setScript(parts[1]).build();
                    }
                    case 3: {
                        return new Locale.Builder().setLanguage(parts[0]).setScript(parts[1]).setRegion(parts[2]).build();
                    }
                }
                return LocaleUtil.processMultipleParts(parts);
            }
            catch (IllformedLocaleException e) {
                LoggerFactory.getLogger(LocaleUtil.class).warn("Failed to create locale with LocaleBuilder", e);
            }
        }
        return null;
    }

    private static Locale processMultipleParts(String[] parts) {
        Locale.Builder localeBuilder = new Locale.Builder().setLanguage(parts[0]).setScript(parts[1]).setRegion(parts[2]);
        try {
            localeBuilder.setVariant(parts[3]);
            return localeBuilder.build();
        }
        catch (IllformedLocaleException e) {
            return localeBuilder.build();
        }
    }

    private static Locale createLocaleWithConstructor(String[] elements) {
        String language = elements[0];
        String country = elements.length > 1 ? elements[1] : "";
        String variant = elements.length > 2 ? elements[2] : "";
        return new Locale(language, country, variant);
    }

    private static boolean isAlpha(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static boolean isAlphaString(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (LocaleUtil.isAlpha(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isScript(String s) {
        return s.length() == 4 && LocaleUtil.isAlphaString(s);
    }

    public static String toRFC4646(Locale locale) {
        if (toggleRouter != null && !toggleRouter.isEnabled("FT_CQ-4332753")) {
            return locale.toString().replace('_', '-');
        }
        boolean country = !locale.getCountry().isEmpty();
        boolean variant = !locale.getVariant().isEmpty();
        boolean script = !locale.getScript().isEmpty();
        StringBuilder result = new StringBuilder(locale.getLanguage());
        if (script) {
            result.append('-').append(locale.getScript());
        }
        if (country) {
            result.append('-').append(locale.getCountry());
        }
        if (variant) {
            result.append('-').append(locale.getVariant());
        }
        return result.toString();
    }

    static {
        ServiceReference serviceReference;
        BundleContext bundleContext;
        Bundle bundle = FrameworkUtil.getBundle(LocaleUtil.class);
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null && (serviceReference = bundleContext.getServiceReference(ToggleRouter.class.getName())) != null) {
            toggleRouter = (ToggleRouter)bundleContext.getService(serviceReference);
        }
    }
}

