/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.components.rendercondition;

import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import javax.servlet.ServletException;

public class PrivilegeRenderCondition
implements RenderCondition {
    @Nonnull
    private AccessControlManager acm;
    @Nonnull
    private String path;
    @Nonnull
    private Privilege[] privileges;

    public PrivilegeRenderCondition(@Nonnull AccessControlManager acm, @Nonnull String path, @Nonnull String[] privilegeNames) throws RepositoryException {
        this.acm = acm;
        this.path = path;
        this.privileges = this.converts(privilegeNames);
    }

    public PrivilegeRenderCondition(@Nonnull AccessControlManager acm, @Nonnull String path, @Nonnull Privilege[] privileges) {
        this.acm = acm;
        this.path = path;
        this.privileges = privileges;
    }

    @Nonnull
    private Privilege[] converts(@Nonnull String[] privilegeNames) throws RepositoryException {
        Privilege[] privileges = new Privilege[privilegeNames.length];
        for (int i = 0; i < privilegeNames.length; ++i) {
            privileges[i] = this.acm.privilegeFromName(privilegeNames[i]);
        }
        return privileges;
    }

    @Override
    public boolean check() throws ServletException {
        try {
            return this.acm.hasPrivileges(this.path, this.privileges);
        }
        catch (RepositoryException e) {
            return false;
        }
    }
}

