/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.nativecomm.msg;

import com.adobe.versioncue.nativecomm.msg.BadMessageException;
import com.adobe.versioncue.nativecomm.msg.INCExternalizable;
import com.adobe.versioncue.nativecomm.msg.NCBool;
import com.adobe.versioncue.nativecomm.msg.NCData;
import com.adobe.versioncue.nativecomm.msg.NCDate;
import com.adobe.versioncue.nativecomm.msg.NCDouble;
import com.adobe.versioncue.nativecomm.msg.NCInt;
import com.adobe.versioncue.nativecomm.msg.NCLong;
import com.adobe.versioncue.nativecomm.msg.NCMap;
import com.adobe.versioncue.nativecomm.msg.NCNumber;
import com.adobe.versioncue.nativecomm.msg.NCString;
import com.adobe.versioncue.nativecomm.msg.NCType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public final class NCList
extends NCType
implements Iterable<NCType> {
    private final ArrayList<NCType> list;

    public NCList() {
        this(10);
    }

    public NCList(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmtpy() {
        return this.list.isEmpty();
    }

    public NCType get(int index) {
        return this.list.get(index);
    }

    public NCType[] get() {
        return this.list.toArray(new NCType[this.list.size()]);
    }

    public boolean contains(NCType val) {
        return this.list.contains(val);
    }

    public NCList add(NCType value) {
        if (value == null) {
            throw new NullPointerException("value can't be null");
        }
        this.list.add(value);
        return this;
    }

    public NCList add(INCExternalizable value) {
        return this.add(value.externalize());
    }

    public NCList add(String value) {
        return this.add(new NCString(value));
    }

    public NCList add(boolean value) {
        return this.add(value ? NCBool.TRUE : NCBool.FALSE);
    }

    public NCList add(int value) {
        return this.add(new NCInt(value));
    }

    public NCList add(long value) {
        return this.add(new NCLong(value));
    }

    public NCList add(double value) {
        return this.add(new NCDouble(value));
    }

    public NCList add(Date value) {
        return this.add(new NCDate(value));
    }

    public NCList add(byte[] value) {
        return this.add(new NCData(value));
    }

    public NCList add(ByteBuffer value) {
        return this.add(new NCData(value));
    }

    public String getString(int index) throws BadMessageException {
        return ((NCString)this.checkedGet(index, NCString.class)).string();
    }

    public boolean getBool(int index) throws BadMessageException {
        return ((NCBool)this.checkedGet(index, NCBool.class)).booleanValue();
    }

    public double getDouble(int index) throws BadMessageException {
        return ((NCNumber)this.checkedGet(index, NCNumber.class)).doubleValue();
    }

    public int getInt(int index) throws BadMessageException {
        return ((NCNumber)this.checkedGet(index, NCNumber.class)).intValue();
    }

    public long getLong(int index) throws BadMessageException {
        return ((NCNumber)this.checkedGet(index, NCNumber.class)).longValue();
    }

    public Date getDate(int index) throws BadMessageException {
        return ((NCDate)this.checkedGet(index, NCDate.class)).date();
    }

    public byte[] getByteArray(int index) throws BadMessageException {
        return ((NCData)this.checkedGet(index, NCData.class)).byteArray();
    }

    public ByteBuffer getBytes(int index) throws BadMessageException {
        return ((NCData)this.checkedGet(index, NCData.class)).bytes();
    }

    public NCList getList(int index) throws BadMessageException {
        return (NCList)this.checkedGet(index, NCList.class);
    }

    public NCMap getMap(int index) throws BadMessageException {
        return (NCMap)this.checkedGet(index, NCMap.class);
    }

    public NCList set(NCType value, int index) {
        if (value == null) {
            throw new NullPointerException("value can't be null");
        }
        this.list.set(index, value);
        return this;
    }

    public NCList clear() {
        this.list.clear();
        return this;
    }

    public NCType remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public Iterator<NCType> iterator() {
        return this.list.iterator();
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other != null && other instanceof NCList) {
            NCList otherArray = (NCList)other;
            return this.list.equals(otherArray.list);
        }
        return false;
    }

    @Override
    public String toString() {
        String nl = System.getProperty("line.separator");
        StringBuilder buf = new StringBuilder(64);
        buf.append(this.getClass().getSimpleName()).append(nl).append('{').append(nl);
        Iterator<NCType> it = this.list.iterator();
        while (it.hasNext()) {
            buf.append("    ");
            buf.append(it.next().toString());
            buf.append(nl);
        }
        buf.append('}');
        return buf.toString();
    }

    private NCType checkedGet(int index, Class<?> expectedType) throws BadMessageException {
        NCType value = this.get(index);
        if (!expectedType.isInstance(value)) {
            throw new BadMessageException("Expected <" + expectedType + "> at [" + index + "]. Actual value: " + value);
        }
        return value;
    }
}

