/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.ut.ISODate;
import com.adobe.xfa.ut.ISOTime;

public final class LogMessageData {
    private int meSeverity;
    private final int mnId;
    private final ISODate mpDate;
    private final ISOTime mpTime;
    private final String msDate;
    private final String msText;
    private final String msTime;
    private final String msSOM;
    private static final String[] msSeverityName = new String[]{"", "t", "i", "w", "vw", "ve", "f"};

    public LogMessageData(int nId, String sText, int eSeverity, ISODate pDate, ISOTime pTime, String sSOM) {
        this.mnId = nId;
        this.msText = sText;
        this.meSeverity = eSeverity;
        this.msSOM = sSOM;
        String sLocalDateFormat = "YYYY-MM-DD";
        String sLocalTimeFormat = "HH:MM:SS.FFFzz";
        this.mpDate = pDate == null ? new ISODate() : pDate;
        this.msDate = this.mpDate.format(sLocalDateFormat);
        this.mpTime = pTime == null ? new ISOTime() : pTime;
        this.mpTime.setLocalTime();
        this.msTime = this.mpTime.format(sLocalTimeFormat);
    }

    public String getDateTime() {
        return this.msDate + 'T' + this.msTime;
    }

    public int getId() {
        return this.mnId;
    }

    public int getSeverity() {
        return this.meSeverity;
    }

    public String getSeverityName() {
        return msSeverityName[this.meSeverity];
    }

    public String getSOMExpression() {
        return this.msSOM;
    }

    public String getText() {
        return this.msText;
    }

    public void setSeverity(int eSeverity) {
        this.meSeverity = eSeverity;
    }
}

