/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.svg;

import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.svg.SVGSchema;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.UnitSpan;

public class SVGNode
extends Element {
    public SVGNode(Element parent, Node prevSibling) {
        super(parent, prevSibling, null, null, null, null, -1, null);
        this.inhibitPrettyPrint(true);
    }

    @Override
    public Attribute defaultAttribute(int eTag) {
        Element poParentImpl;
        if (!(this.getClassTag() != 725 && this.getClassTag() != 726 || eTag != 728 && eTag != 729 && eTag != 730 && eTag != 731 && eTag != 732 && eTag != 727 || (poParentImpl = this.getXFAParent()) == null)) {
            return poParentImpl.getAttribute(eTag);
        }
        return super.defaultAttribute(eTag);
    }

    @Override
    public Attribute getAttribute(int eTag, boolean bPeek, boolean bValidate) {
        Element poParentImpl;
        Attribute a;
        if (!((bPeek || this.getClassTag() != 725) && this.getClassTag() != 726 || (a = super.getAttribute(eTag, true, false)) != null || eTag != 728 && eTag != 729 && eTag != 730 && eTag != 731 && eTag != 732 && eTag != 727 || (poParentImpl = this.getXFAParent()) == null)) {
            return poParentImpl.getAttribute(eTag, bPeek, bValidate);
        }
        return super.getAttribute(eTag, bPeek, bValidate);
    }

    boolean isRegionGroup(boolean bCheckCaption) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "SVGNode#isRegionGroup");
    }

    public SVGNode getRegionGroup(boolean bCheckCaption) {
        int eTag = this.getClassTag();
        switch (eTag) {
            case 721: {
                if (this.isRegionGroup(bCheckCaption)) {
                    return this;
                }
                SVGNode parent = (SVGNode)this.getXFAParent();
                if (parent != null) {
                    return parent.getRegionGroup(bCheckCaption);
                }
            }
            case 723: {
                for (SVGNode child = (SVGNode)this.getFirstXFAChild(); child != null; child = (SVGNode)child.getNextXFASibling()) {
                    if (child.getClassTag() != 721 || !child.isRegionGroup(bCheckCaption)) continue;
                    return child;
                }
                return null;
            }
        }
        SVGNode parent = (SVGNode)this.getXFAParent();
        while (parent instanceof SVGNode) {
            if (parent.getClassTag() == 723) {
                return parent.getRegionGroup(bCheckCaption);
            }
            parent = (SVGNode)parent.getXFAParent();
        }
        return null;
    }

    void setMeasurement(int eTag, UnitSpan value) {
        String sTemp = Integer.toString(value.valueAsUnit(19));
        this.setAttribute(new StringAttr(SVGSchema.getSVGSchema().getAtom(eTag), sTemp), eTag);
    }

    public UnitSpan getMeasurement(int eTag) {
        String sNum = this.getAttribute(eTag).toString();
        int nNum = Integer.parseInt(sNum);
        return new UnitSpan(19, 19, nNum);
    }

    public void parseTransform(UnitSpan x, UnitSpan y, int r) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "SVGNode#parseTransform");
    }

    void setColor(int eTag, int r, int g, int b) {
        if (r < 0) {
            r = 0;
        }
        if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        }
        if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        }
        if (b > 255) {
            b = 255;
        }
        int nHexNum = b | g << 8 | r << 16;
        String cHexNum = Integer.toString(nHexNum, 16);
        this.setAttribute(new StringAttr(SVGSchema.getSVGSchema().getAtom(eTag), cHexNum), eTag);
    }

    void getColor(int eTag, int r, int g, int b) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "SVGNode#getColor");
    }

    public UnitSpan getSVGWidth() {
        SVGNode svg;
        for (svg = this; svg != null && !svg.isSameClass(723); svg = (SVGNode)svg.getXFAParent()) {
        }
        if (svg == null) {
            return UnitSpan.ZERO;
        }
        String sW = svg.getAttribute(739).toString();
        return new UnitSpan(sW);
    }

    public UnitSpan getSVGHeight() {
        SVGNode svg;
        for (svg = this; svg != null && !svg.isSameClass(723); svg = (SVGNode)svg.getXFAParent()) {
        }
        if (svg == null) {
            return UnitSpan.ZERO;
        }
        String sH = svg.getAttribute(733).toString();
        return new UnitSpan(sH);
    }

    public void storeGlyphs(Object oFontInstance, int[] glyphs, int nGlyphs) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "SVGNode#storeGlyphs");
    }

    public void storeText(Object oFontInstance, String text) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "SVGNode#storeText");
    }

    void getGlyphs(Object oFontInstance, int nGlyphs) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "SVGNode#getGlyphs");
    }

    String getText(Object oFontInstance) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "SVGNode#getText");
    }
}

