/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.MsgFormat;
import java.util.ArrayList;
import java.util.List;

public final class MsgFormatPos {
    private boolean mbResolved;
    private int mnResId;
    private MsgFormat moFmt;
    private final List<Integer> moParmPosns = new ArrayList<Integer>();
    private final List<String> moParms = new ArrayList<String>();

    protected MsgFormatPos() {
    }

    public MsgFormatPos(MsgFormatPos oSource) {
        this.moFmt = new MsgFormat(oSource.moFmt);
        this.assign(oSource);
    }

    public MsgFormatPos(int nResId) {
        this.moFmt = new MsgFormat(nResId);
        this.mnResId = nResId;
        this.init();
    }

    public MsgFormatPos(int nResId, String sOut) {
        this.mnResId = nResId;
        this.moFmt = new MsgFormat(this.mnResId);
        this.init();
        this.format(sOut);
    }

    public MsgFormatPos(String sSource) {
        this.moFmt = new MsgFormat(sSource);
        this.init();
    }

    public MsgFormatPos(String sSource, String sOut) {
        this.moFmt = new MsgFormat(sSource, sOut);
        this.init();
        this.format(sOut);
    }

    public MsgFormatPos assign(MsgFormatPos oSource) {
        this.moFmt = oSource.moFmt;
        this.mbResolved = oSource.mbResolved;
        this.moParmPosns.addAll(oSource.moParmPosns);
        this.moParms.addAll(oSource.moParms);
        this.mnResId = oSource.mnResId;
        return this;
    }

    public MsgFormatPos format(int nResId) {
        return this.format(new MsgFormat(nResId).toString());
    }

    public MsgFormatPos format(String sOut) {
        this.mbResolved = false;
        this.moParms.add(sOut);
        return this;
    }

    public String getParm(int nIndex) {
        this.resolve();
        return this.moFmt.getParm(nIndex);
    }

    public int getParmCount() {
        this.resolve();
        return this.moFmt.getParmCount();
    }

    void init() {
        this.mbResolved = false;
        StringBuilder sSrc = new StringBuilder(this.moFmt.sourceString());
        int nLen = sSrc.length();
        for (int i = 0; i < nLen; ++i) {
            if (sSrc.charAt(i) != '%' || i >= nLen) continue;
            if ('0' <= sSrc.charAt(++i) && sSrc.charAt(i) <= '9') {
                this.moParmPosns.add(sSrc.charAt(i) - 48);
                sSrc.setCharAt(i, 's');
                continue;
            }
            if (sSrc.charAt(i) != 's') continue;
            int nPos = this.moParmPosns.size();
            this.moParmPosns.add(nPos);
            sSrc.setCharAt(i, 's');
        }
        this.moFmt = new MsgFormat(sSrc.toString());
    }

    public int resId() {
        return this.mnResId;
    }

    private void resolve() {
        int n;
        int i;
        this.mbResolved = true;
        int nParms = this.moParms.size();
        int nSize = this.moParmPosns.size();
        if (nSize == 0 || nParms == 0) {
            return;
        }
        int nMin = this.moParmPosns.get(0);
        for (i = 1; i < nSize; ++i) {
            if (this.moParmPosns.get(i) >= nMin) continue;
            nMin = this.moParmPosns.get(i);
        }
        for (i = 0; i < nSize && (n = this.moParmPosns.get(i) - nMin) < nParms; ++i) {
            this.moFmt.format(this.moParms.get(n));
        }
        while (i < nSize) {
            this.moFmt.format("");
            ++i;
        }
        this.moParms.clear();
        this.moParmPosns.clear();
    }

    public String toString() {
        this.resolve();
        return this.moFmt.toString();
    }
}

