/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import com.adobe.xfa.ut.BooleanHolder;
import com.adobe.xfa.ut.DateTimeUtil;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ISODate;
import com.adobe.xfa.ut.ISOTime;
import com.adobe.xfa.ut.LcData;
import com.adobe.xfa.ut.LcDate;
import com.adobe.xfa.ut.LcNum;
import com.adobe.xfa.ut.LcText;
import com.adobe.xfa.ut.LcTime;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public final class PictureFmt {
    private final String msLocale;
    static final String gsPictureLiterals = "\"' ,-./:?+*$()";
    static final String gsNull = "null";
    static final String gsZero = "zero";
    static final String gsNum = "num";
    static final String gsText = "text";
    static final String gsDate = "date";
    static final String gsTime = "time";
    static final String gsDateTime = "datetime";
    static final String gsShort = "short";
    static final String gsMedium = "medium";
    static final String gsLong = "long";
    static final String gsFull = "full";
    static final String gsDefault = "default";
    static final String gsInteger = "integer";
    static final String gsDecimal = "decimal";
    static final String gsCurrency = "currency";
    static final String gsPercent = "percent";

    public static Point resolveRange(String s, int startIndex, int endIndex) {
        if (startIndex > s.length()) {
            startIndex = s.length();
        }
        if (endIndex > s.length()) {
            endIndex = s.length();
        }
        return new Point(startIndex, endIndex);
    }

    public PictureFmt(String sLocale) {
        this.msLocale = sLocale;
    }

    public boolean format(String sSource, String sPicture, StringBuilder sResult) {
        sResult.setLength(0);
        if (StringUtils.isEmpty(sPicture)) {
            sResult.append(sSource);
            return true;
        }
        ArrayList<String> oAlt = new ArrayList<String>();
        if (!PictureFmt.getAlternates(sPicture, oAlt)) {
            return true;
        }
        boolean bSuccess = false;
        for (int i = 0; i < oAlt.size(); ++i) {
            String sMask = PictureFmt.interpret((String)oAlt.get(i));
            StringBuilder sDateMask = new StringBuilder();
            StringBuilder sTimeMask = new StringBuilder();
            if (sSource == null) {
                if (PictureFmt.isNullPicture(sMask)) {
                    bSuccess = PictureFmt.formatNull(sSource, sMask, this.msLocale, sResult);
                }
            } else if (sSource.length() == 0) {
                if (PictureFmt.isEmptyPicture(sMask)) {
                    bSuccess = true;
                    sResult.setLength(0);
                }
            } else {
                bSuccess = PictureFmt.isNumericPicture(sMask) ? PictureFmt.formatNumeric(sSource, sMask, this.msLocale, sResult) : (PictureFmt.isNullPicture(sMask) ? PictureFmt.formatNull(sSource, sMask, this.msLocale, sResult) : (PictureFmt.isZeroPicture(sMask) ? PictureFmt.formatZero(sSource, sMask, this.msLocale, sResult) : (PictureFmt.isDateTimePicture(sMask, sDateMask, sTimeMask) ? PictureFmt.formatDateTime(sSource, sMask, sDateMask.toString(), sTimeMask.toString(), this.msLocale, sResult, true) : (PictureFmt.isDatePicture(sMask) ? PictureFmt.formatDate(sSource, sMask, this.msLocale, sResult, true) : (PictureFmt.isTimePicture(sMask) ? PictureFmt.formatTime(sSource, sMask, this.msLocale, sResult, true) : (PictureFmt.isTextPicture(sMask) ? PictureFmt.formatText(sSource, sMask, this.msLocale, sResult) : (PictureFmt.isCompoundPicture(sMask) ? PictureFmt.formatCompound(sSource, sMask, this.msLocale, sResult) : false)))))));
            }
            if (bSuccess) break;
        }
        return bSuccess;
    }

    public String parse(String sSource, String sPicture, BooleanHolder pbSuccess) {
        if (StringUtils.isEmpty(sPicture)) {
            return sSource;
        }
        if (sSource == null) {
            if (pbSuccess != null) {
                pbSuccess.value = true;
            }
            return null;
        }
        ArrayList<String> oAlt = new ArrayList<String>();
        if (!PictureFmt.getAlternates(sPicture, oAlt)) {
            return "";
        }
        boolean bSuccess = false;
        StringHolder sResult = new StringHolder();
        StringBuilder sDateMask = new StringBuilder();
        StringBuilder sTimeMask = new StringBuilder();
        for (int i = 0; i < oAlt.size(); ++i) {
            String sMask = PictureFmt.interpret((String)oAlt.get(i));
            sDateMask.setLength(0);
            sTimeMask.setLength(0);
            String string = sResult.value = sSource.length() > 0 ? "" : null;
            bSuccess = PictureFmt.isNumericPicture(sMask) ? PictureFmt.parseNumeric(sSource, sMask, this.msLocale, sResult) : (PictureFmt.isNullPicture(sMask) ? PictureFmt.parseNull(sSource, sMask, this.msLocale, sResult) : (PictureFmt.isZeroPicture(sMask) ? PictureFmt.parseZero(sSource, sMask, this.msLocale, sResult) : (PictureFmt.isDateTimePicture(sMask, sDateMask, sTimeMask) ? PictureFmt.parseDateTime(sSource, sMask, sDateMask.toString(), sTimeMask.toString(), this.msLocale, sResult, true) : (PictureFmt.isDatePicture(sMask) ? PictureFmt.parseDate(sSource, sMask, this.msLocale, sResult, true) : (PictureFmt.isTimePicture(sMask) ? PictureFmt.parseTime(sSource, sMask, this.msLocale, sResult, true) : (PictureFmt.isTextPicture(sMask) ? PictureFmt.parseText(sSource, sMask, this.msLocale, sResult) : (PictureFmt.isCompoundPicture(sMask) ? PictureFmt.parseCompound(sSource, sMask, this.msLocale, sResult) : false)))))));
            if (bSuccess) break;
        }
        if (pbSuccess != null) {
            pbSuccess.value = bSuccess;
        }
        return sResult.value;
    }

    public static String FF99ToXFA(String sPicture) {
        int picLen = sPicture.length();
        int needs_escapes = 0;
        for (int i = 0; i < picLen; ++i) {
            char chr = sPicture.charAt(i);
            if (chr != '\"' && chr != '\'') continue;
            ++needs_escapes;
        }
        StringBuilder sRes = new StringBuilder(sPicture.length() + needs_escapes);
        boolean START = false;
        boolean SGLQUOTE = true;
        int DBLQUOTE = 2;
        int eState = 0;
        int i = 0;
        while (i < picLen) {
            char chr = sPicture.charAt(i++);
            if (eState == 0) {
                if (chr == '\'') {
                    eState = 1;
                } else if (chr == '\"') {
                    eState = 2;
                    chr = '\'';
                }
            } else if (eState == 1) {
                if (chr == '\'') {
                    eState = 0;
                } else if (chr == '\"') {
                    sRes.append(chr);
                }
            } else if (eState == 2) {
                if (chr == '\"') {
                    eState = 0;
                    chr = '\'';
                } else if (chr == '\'') {
                    sRes.append(chr);
                }
            }
            sRes.append(chr);
        }
        return sRes.toString();
    }

    public static boolean formatCompound(String sSource, String sPicture, String sLocale, StringBuilder sResult) {
        MsgFormatPos oMessage = new MsgFormatPos(ResId.UNSUPPORTED_OPERATION, "PictureFmt#formatCompound");
        oMessage.format("formatCompound");
        throw new ExFull(oMessage);
    }

    public static boolean formatDate(String sSource, String sPicture, String sLocale, StringBuilder sResult, boolean bAsLocal) {
        ISODate oDate;
        assert (sResult != null);
        sResult.setLength(0);
        if (sSource == null) {
            return false;
        }
        StringBuilder sCategory = new StringBuilder();
        StringBuilder sLoc = new StringBuilder(sLocale);
        StringBuilder sDateMask = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCategory, sLoc, sDateMask) && !sCategory.toString().equals(gsDate)) {
            sDateMask.replace(0, sDateMask.length(), sPicture);
        }
        if ((oDate = new ISODate(sSource, sLoc.toString())).isValid()) {
            if (bAsLocal) {
                oDate.setLocalDate();
            }
            sResult.append(oDate.format(sDateMask.toString()));
        }
        return sResult.length() != 0;
    }

    public static boolean formatDateTime(String sSource, String sPicture, String sDateMask, String sTimeMask, String sLocale, StringBuilder sResult, boolean bAsLocal) {
        String sSourceTime;
        String sSourceDate;
        assert (sResult != null);
        sResult.setLength(0);
        if (sSource == null) {
            return false;
        }
        boolean bValid = true;
        String sFormattedDate = "";
        String sFormattedTime = "";
        StringBuilder sLoc = new StringBuilder(sLocale);
        StringBuilder sCategory = new StringBuilder();
        StringBuilder sDateSubMask = new StringBuilder();
        StringBuilder sTimeSubMask = new StringBuilder();
        if (!PictureFmt.isSubPicture(sDateMask, 0, sCategory, sLoc, sDateSubMask) && !sCategory.toString().startsWith(gsDate)) {
            sDateSubMask.replace(0, sDateSubMask.length(), sDateMask);
        }
        String sDateLocale = sLoc.toString();
        sLoc.replace(0, sLoc.length(), sLocale);
        if (!PictureFmt.isSubPicture(sTimeMask, 0, sCategory, sLoc, sTimeSubMask) && !sCategory.toString().startsWith(gsTime)) {
            sTimeSubMask.replace(0, sTimeSubMask.length(), sTimeMask);
        }
        String sTimeLocale = sLoc.toString();
        int nFound = sSource.indexOf(84);
        if (nFound >= 0) {
            sSourceDate = sSource.substring(0, nFound);
            sSourceTime = sSource.substring(nFound + 1);
            ISODate oISODate = new ISODate(sSourceDate, sDateLocale);
            ISOTime oISOTime = new ISOTime(sSourceTime, sTimeLocale);
            boolean bl = bValid = oISODate.isValid() && oISOTime.isValid();
            if (bValid) {
                if (bAsLocal) {
                    oISODate.setLocalDate();
                    oISOTime.setLocalTime();
                }
                sFormattedDate = oISODate.format(sDateSubMask.toString());
                sFormattedTime = oISOTime.format(sTimeSubMask.toString());
            }
        } else {
            nFound = sSource.indexOf(32);
            if (nFound >= 0) {
                sSourceDate = sSource.substring(0, nFound);
                sSourceTime = sSource.substring(nFound + 1);
                String sSourceDateFmt = new LcData(sLocale).getDateFormat(1);
                String sSourceTimeFmt = new LcData(sLocale).getTimeFormat(1);
                LcDate oDate = new LcDate(sSourceDate, sSourceDateFmt, sDateLocale, 30);
                LcTime oTime = new LcTime(sSourceTime, sSourceTimeFmt, sTimeLocale);
                boolean bl = bValid = oDate.isValid() && oTime.isValid();
                if (bValid) {
                    if (bAsLocal) {
                        oDate.setLocalDate();
                        oTime.setLocalTime();
                    }
                    sFormattedDate = oDate.format(sDateSubMask.toString());
                    sFormattedTime = oTime.format(sTimeSubMask.toString());
                }
            } else {
                bValid = false;
            }
        }
        if (bValid) {
            if (sPicture.startsWith(gsDateTime)) {
                sResult.append(sDateMask);
                sResult.append(' ');
                sResult.append(sTimeMask);
            } else {
                sResult.replace(0, sResult.length(), sPicture);
            }
            int nCharPos = 0;
            while (nCharPos < sResult.length()) {
                char cChar;
                int nPrevPos = nCharPos;
                if ((cChar = sResult.charAt(nCharPos++)) != '\'') continue;
                StringBuilder sLiteral = new StringBuilder();
                int nEnd = nCharPos;
                int n = PictureFmt.getLiteralSubstr(sResult.toString(), cChar, nEnd, sLiteral);
                if (n <= nEnd) continue;
                nEnd = n;
                sResult.replace(nPrevPos, nEnd, sLiteral.toString());
                nCharPos = nEnd - 2;
            }
            int nDateTag = sResult.indexOf(gsDate);
            int nEnd = sResult.substring(nDateTag, sResult.length()).indexOf(125);
            sResult.replace(nDateTag, nDateTag + nEnd + 1, sFormattedDate);
            int nTimeTag = sResult.indexOf(gsTime);
            nEnd = sResult.substring(nTimeTag, sResult.length()).indexOf(125);
            sResult.replace(nTimeTag, nTimeTag + nEnd + 1, sFormattedTime);
        }
        return bValid;
    }

    public static boolean formatNull(String sSource, String sPicture, String sLocale, StringBuilder sResult) {
        assert (sResult != null);
        sResult.setLength(0);
        if (sSource != null) {
            return false;
        }
        StringBuilder sCategory = new StringBuilder();
        StringBuilder sLoc = new StringBuilder(sLocale);
        StringBuilder sNullMask = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCategory, sLoc, sNullMask) && !sCategory.toString().equals(gsNull)) {
            sNullMask.replace(0, sNullMask.length(), sPicture);
        }
        if (sNullMask.length() == 0) {
            return true;
        }
        LcNum oNum = new LcNum("0", sLoc.toString());
        if (oNum.isValid()) {
            sResult.append(oNum.format(sNullMask.toString(), null));
        }
        return sResult.length() != 0;
    }

    public static boolean formatNumeric(String sSource, String sPicture, String sLocale, StringBuilder sResult) {
        LcNum oNum;
        assert (sResult != null);
        sResult.setLength(0);
        if (sSource == null) {
            return false;
        }
        StringBuilder sCategory = new StringBuilder();
        StringBuilder sLoc = new StringBuilder(sLocale);
        StringBuilder sNumMask = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCategory, sLoc, sNumMask) && !sCategory.toString().equals(gsNum)) {
            sNumMask.replace(0, sNumMask.length(), sPicture);
        }
        if ((oNum = new LcNum(sSource, sLoc.toString())).isValid()) {
            sResult.append(oNum.format(sNumMask.toString(), null));
        }
        return sResult.length() != 0;
    }

    public static boolean formatText(String sSource, String sPicture, String sLocale, StringBuilder sResult) {
        LcText oText;
        assert (sResult != null);
        sResult.setLength(0);
        StringBuilder sLoc = new StringBuilder(sLocale);
        StringBuilder sCategory = new StringBuilder();
        StringBuilder sTextMask = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCategory, sLoc, sTextMask) && !sCategory.toString().equals(gsText)) {
            sTextMask.replace(0, sTextMask.length(), sPicture);
        }
        if ((oText = new LcText(sSource, sLoc.toString())).isValid()) {
            sResult.append(oText.format(sTextMask.toString()));
        }
        return sResult.length() != 0;
    }

    public static boolean formatTime(String sSource, String sPicture, String sLocale, StringBuilder sResult, boolean bAsLocal) {
        ISOTime oTime;
        assert (sResult != null);
        sResult.setLength(0);
        if (sSource == null) {
            return false;
        }
        StringBuilder sCategory = new StringBuilder();
        StringBuilder sLoc = new StringBuilder(sLocale);
        StringBuilder sTimeMask = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCategory, sLoc, sTimeMask) && !sCategory.toString().equals(gsTime)) {
            sTimeMask.replace(0, sTimeMask.length(), sPicture);
        }
        if ((oTime = new ISOTime(sSource, sLoc.toString())).isValid()) {
            if (bAsLocal) {
                oTime.setLocalTime();
            }
            sResult.append(oTime.format(sTimeMask.toString()));
        }
        return sResult.length() != 0;
    }

    public static boolean formatZero(String sSource, String sPicture, String sLocale, StringBuilder sResult) {
        assert (sResult != null);
        sResult.setLength(0);
        if (sSource == null) {
            return false;
        }
        if (!sSource.equals("0")) {
            return false;
        }
        StringBuilder sCategory = new StringBuilder();
        StringBuilder sLoc = new StringBuilder(sLocale);
        StringBuilder sZeroMask = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCategory, sLoc, sZeroMask) && !sCategory.toString().equals(gsZero)) {
            sZeroMask.replace(0, sZeroMask.length(), sPicture);
        }
        if (sZeroMask.length() == 0) {
            return true;
        }
        LcNum oNum = new LcNum(sSource, sLoc.toString());
        if (oNum.isValid()) {
            sResult.append(oNum.format(sZeroMask.toString(), null));
        }
        return sResult.length() != 0;
    }

    public static boolean getAlternates(String sSource, List<String> oAlternates) {
        int i;
        char prevChr = '\u0000';
        int chrCnt = 0;
        boolean inQuoted = false;
        boolean inQuoteQuoted = false;
        int picLen = sSource.length();
        int k = i = 0;
        while (i < picLen) {
            int j = i;
            char chr = sSource.charAt(i++);
            if (inQuoteQuoted) {
                if (chr == '\'') {
                    chrCnt = 0;
                } else {
                    inQuoted = false;
                    chrCnt = 1;
                    prevChr = chr;
                }
                inQuoteQuoted = false;
                continue;
            }
            if (inQuoted) {
                if (chr == '\'') {
                    inQuoteQuoted = true;
                }
                ++chrCnt;
                prevChr = chr;
                continue;
            }
            if (chr == '\'') {
                if (chrCnt > 0) {
                    if (prevChr == '|') {
                        oAlternates.add(sSource.substring(k, j - 1));
                        k = j;
                    }
                    chrCnt = 0;
                    prevChr = '\u0000';
                }
                inQuoted = true;
                continue;
            }
            if (DateTimeUtil.matchChr("(%$,.)89BCDERSVZbcdrsvzt", chr) || DateTimeUtil.matchChr("9AO0Xt", chr) || DateTimeUtil.matchChr("DJMEeYWwGgt", chr) || DateTimeUtil.matchChr("hkHKMSFAZzt", chr) || 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z') {
                if (chr != prevChr) {
                    if (chrCnt > 0) {
                        if (prevChr == '|') {
                            oAlternates.add(sSource.substring(k, j - 1));
                            k = j;
                        }
                        chrCnt = 0;
                    }
                    prevChr = chr;
                }
                ++chrCnt;
                continue;
            }
            if (chrCnt > 0) {
                if (prevChr == '|') {
                    oAlternates.add(sSource.substring(k, j - 1));
                    k = j;
                }
                chrCnt = 1;
                prevChr = chr;
                continue;
            }
            if (prevChr == '|') {
                oAlternates.add(sSource.substring(k, j - 1));
                k = j;
            }
            chrCnt = 1;
            prevChr = chr;
        }
        if (inQuoteQuoted) {
            inQuoted = false;
        }
        if (inQuoted) {
            int n = oAlternates.size();
            while (n-- > 0) {
                oAlternates.remove(n);
            }
            return false;
        }
        if (prevChr > '\u0000' && chrCnt > 0) {
            assert (i == picLen);
            oAlternates.add(sSource.substring(k, i));
        }
        return true;
    }

    public static boolean getLocaleFromPicture(String sPicture, String sCategory, StringBuilder sLocale) {
        int nPictIndex = 0;
        int nPrevIndex = 0;
        sLocale.setLength(0);
        while (nPictIndex < sPicture.length()) {
            int nIndex;
            char cChar;
            nPrevIndex = nPictIndex;
            if ((cChar = sPicture.charAt(nPictIndex++)) == '\'') {
                nIndex = PictureFmt.getLiteralSubstr(sPicture, cChar, nPictIndex, null);
                if (nIndex == nPictIndex) {
                    return false;
                }
                nPictIndex = nIndex;
                continue;
            }
            if (PictureFmt.isCharAlphabetic(cChar)) {
                int nLocaleEnd;
                int nCategoryBeg = nPrevIndex;
                if (nPictIndex == sPicture.length()) {
                    return false;
                }
                nPrevIndex = nPictIndex;
                while (PictureFmt.isCharAlphabetic(sPicture.charAt(nPictIndex++))) {
                    nPrevIndex = nPictIndex;
                    if (nPictIndex != sPicture.length()) continue;
                    return false;
                }
                int nCategoryEnd = nPrevIndex;
                int nLocaleBeg = nLocaleEnd = nPictIndex;
                nPictIndex = nPrevIndex;
                if ((cChar = sPicture.charAt(nPictIndex++)) == '(') {
                    nLocaleBeg = nPictIndex;
                    if (nPictIndex == sPicture.length()) {
                        return false;
                    }
                    nPrevIndex = nPictIndex;
                    while (sPicture.charAt(nPictIndex++) != ')') {
                        nPrevIndex = nPictIndex;
                        if (nPictIndex != sPicture.length()) continue;
                        return false;
                    }
                    nLocaleEnd = nPrevIndex;
                    cChar = sPicture.charAt(nPictIndex++);
                }
                if (cChar == '{') {
                    while (true) {
                        if (nPictIndex == sPicture.length()) {
                            return false;
                        }
                        if ((cChar = sPicture.charAt(nPictIndex++)) == '\'') {
                            nIndex = PictureFmt.getLiteralSubstr(sPicture, cChar, nPictIndex, null);
                            if (nIndex == nPictIndex) {
                                return false;
                            }
                            nPictIndex = nIndex;
                            continue;
                        }
                        if (cChar == '}') break;
                    }
                    String sCandidate = sPicture.substring(nCategoryBeg, nCategoryEnd);
                    if (sCandidate.equals(sCategory)) {
                        if (sLocale.length() != 0) {
                            return false;
                        }
                        sLocale.replace(0, sLocale.length(), sPicture.substring(nLocaleBeg, nLocaleEnd));
                        continue;
                    }
                }
                return false;
            }
            if (PictureFmt.isCharNumeric(cChar) || PictureFmt.isCharLiteral(cChar)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasSubPicture(String sPicture, int nPictIndex, StringBuilder sCategory, StringBuilder sLocale, StringBuilder sSubMask) {
        String sSubCategory = "";
        while (nPictIndex < sPicture.length()) {
            int nIndex;
            char cChar;
            int nPrevIndex = nPictIndex;
            if ((cChar = sPicture.charAt(nPictIndex++)) == '\'') {
                int nLiteralBeg = nPrevIndex;
                nIndex = PictureFmt.getLiteralSubstr(sPicture, cChar, nPictIndex, null);
                if (nIndex == nPictIndex) {
                    return false;
                }
                nPictIndex = nIndex;
                int nLiteralEnd = nPictIndex - 1;
                sSubMask.append(sPicture, nLiteralBeg, nLiteralEnd + 1);
                continue;
            }
            if (PictureFmt.isCharAlphabetic(cChar)) {
                int nLocaleEnd;
                int nCategoryBeg = nPrevIndex;
                if (nPictIndex == sPicture.length()) {
                    return false;
                }
                nPrevIndex = nPictIndex;
                while (PictureFmt.isCharAlphabetic(sPicture.charAt(nPictIndex++))) {
                    nPrevIndex = nPictIndex;
                    if (nPictIndex != sPicture.length()) continue;
                    return false;
                }
                int nCategoryEnd = nPrevIndex;
                int nLocaleBeg = nLocaleEnd = nPictIndex;
                nPictIndex = nPrevIndex;
                if ((cChar = sPicture.charAt(nPictIndex++)) == '.') {
                    int nSubCategoryBeg = nPictIndex;
                    if (nPictIndex == sPicture.length()) {
                        return false;
                    }
                    nPrevIndex = nPictIndex;
                    while ((cChar = sPicture.charAt(nPictIndex++)) != '(' && cChar != '{') {
                        nPrevIndex = nPictIndex;
                        if (nPictIndex != sPicture.length()) continue;
                        return false;
                    }
                    int nSubCategoryEnd = nPrevIndex;
                    sSubCategory = sPicture.substring(nSubCategoryBeg, nSubCategoryEnd);
                }
                if (cChar == '(') {
                    nLocaleBeg = nPictIndex;
                    if (nPictIndex == sPicture.length()) {
                        return false;
                    }
                    nPrevIndex = nPictIndex;
                    while (sPicture.charAt(nPictIndex++) != ')') {
                        nPrevIndex = nPictIndex;
                        if (nPictIndex != sPicture.length()) continue;
                        return false;
                    }
                    nLocaleEnd = nPrevIndex;
                    if (nLocaleEnd > nLocaleBeg) {
                        sLocale.replace(0, sLocale.length(), sPicture.substring(nLocaleBeg, nLocaleEnd));
                    }
                    cChar = sPicture.charAt(nPictIndex++);
                }
                if (cChar == '{') {
                    int nSubMaskBeg = nPictIndex;
                    while (true) {
                        if (nPictIndex >= sPicture.length()) {
                            return false;
                        }
                        nPrevIndex = nPictIndex;
                        if ((cChar = sPicture.charAt(nPictIndex++)) == '\'') {
                            nIndex = PictureFmt.getLiteralSubstr(sPicture, cChar, nPictIndex, null);
                            if (nIndex == nPictIndex) {
                                return false;
                            }
                            nPictIndex = nIndex;
                            continue;
                        }
                        if (cChar == '}') break;
                    }
                    int nSubMaskEnd = nPrevIndex;
                    String sCandidate = sPicture.substring(nCategoryBeg, nCategoryEnd);
                    if (sCandidate.equals(gsNull) || sCandidate.equals(gsZero) || sCandidate.equals(gsText)) {
                        sCategory.append(sCandidate);
                        if (sLocale.length() == 0) {
                            sLocale.append("en_US");
                        }
                        sSubMask.append(sPicture, nSubMaskBeg, nSubMaskEnd);
                        continue;
                    }
                    if (sCandidate.equals(gsDate) || sCandidate.equals(gsTime)) {
                        sCategory.append(sCandidate);
                        if (sLocale.length() == 0) {
                            sLocale.append("en_US");
                        }
                        String sFmt = null;
                        if (sSubCategory.length() == 0) {
                            sFmt = sPicture.substring(nSubMaskBeg, nSubMaskEnd);
                        } else if (sSubCategory.equals(gsShort)) {
                            LcData oData = new LcData(sLocale.toString());
                            sFmt = sCandidate.equals(gsDate) ? oData.getDateFormat(1) : oData.getTimeFormat(1);
                        } else if (sSubCategory.equals(gsMedium)) {
                            LcData oData = new LcData(sLocale.toString());
                            sFmt = sCandidate.equals(gsDate) ? oData.getDateFormat(2) : oData.getTimeFormat(2);
                        } else if (sSubCategory.equals(gsLong)) {
                            LcData oData = new LcData(sLocale.toString());
                            sFmt = sCandidate.equals(gsDate) ? oData.getDateFormat(3) : oData.getTimeFormat(3);
                        } else if (sSubCategory.equals(gsFull)) {
                            LcData oData = new LcData(sLocale.toString());
                            sFmt = sCandidate.equals(gsDate) ? oData.getDateFormat(4) : oData.getTimeFormat(4);
                        } else if (sSubCategory.equals(gsDefault)) {
                            LcData oData = new LcData(sLocale.toString());
                            sFmt = sCandidate.equals(gsDate) ? oData.getDateFormat(0) : oData.getTimeFormat(0);
                        } else {
                            return false;
                        }
                        sSubMask.append(sFmt);
                        continue;
                    }
                    if (sCandidate.equals(gsNum)) {
                        sCategory.append(sCandidate);
                        if (sLocale.length() == 0) {
                            sLocale.append("en_US");
                        }
                        LcData oData = new LcData(sLocale.toString());
                        String sFmt = null;
                        if (sSubCategory.length() == 0) {
                            sFmt = sPicture.substring(nSubMaskBeg, nSubMaskEnd);
                        } else if (sSubCategory.equals(gsInteger)) {
                            int nOptn = 1;
                            sFmt = oData.getNumberFormat(0, nOptn);
                        } else if (sSubCategory.equals(gsDecimal)) {
                            int nOptn = LcData.withPrecision(-1) | 1 | 8;
                            sFmt = oData.getNumberFormat(1, nOptn);
                        } else if (sSubCategory.equals(gsCurrency)) {
                            int nOptn = LcData.withPrecision(-1) | 1 | 8;
                            sFmt = oData.getNumberFormat(2, nOptn);
                        } else if (sSubCategory.equals(gsPercent)) {
                            int nOptn = 1;
                            sFmt = oData.getNumberFormat(3, nOptn);
                        } else {
                            return false;
                        }
                        sSubMask.append(sFmt);
                        continue;
                    }
                    if (sCandidate.equals(gsDateTime)) {
                        sCategory.append(sCandidate);
                        if (sLocale.length() == 0) {
                            sLocale.append("en_US");
                        }
                        LcData oData = new LcData(sLocale.toString());
                        int nOptn = 1;
                        String sFmt = null;
                        if (sSubCategory.equals(gsShort)) {
                            sFmt = oData.getDateTimeFormat(1, nOptn);
                        } else if (sSubCategory.equals(gsMedium)) {
                            sFmt = oData.getDateTimeFormat(2, nOptn);
                        } else if (sSubCategory.equals(gsLong)) {
                            sFmt = oData.getDateTimeFormat(3, nOptn);
                        } else if (sSubCategory.equals(gsFull)) {
                            sFmt = oData.getDateTimeFormat(4, nOptn);
                        } else if (sSubCategory.equals(gsDefault)) {
                            sFmt = oData.getDateTimeFormat(0, nOptn);
                        } else {
                            return false;
                        }
                        sSubMask.append(sFmt);
                        continue;
                    }
                }
                return false;
            }
            if (PictureFmt.isCharNumeric(cChar)) {
                sSubMask.append(cChar);
                continue;
            }
            if (PictureFmt.isCharLiteral(cChar)) {
                sSubMask.append(cChar);
                continue;
            }
            return false;
        }
        return true;
    }

    private static String interpret(String sSrc) {
        int sSrcLen = sSrc.length();
        StringBuilder sDst = new StringBuilder();
        int i = 0;
        while (i < sSrcLen) {
            char ch;
            if ((ch = sSrc.charAt(i++)) == '\\' && sSrc.charAt(i + 1) == 'u' && i + 5 < sSrcLen && PictureFmt.isCharHexDigit(sSrc.charAt(i + 2)) && PictureFmt.isCharHexDigit(sSrc.charAt(i + 3)) && PictureFmt.isCharHexDigit(sSrc.charAt(i + 4)) && PictureFmt.isCharHexDigit(sSrc.charAt(i + 5))) {
                String sHex = sSrc.substring(i + 2, i + 6);
                try {
                    char hHex = (char)Integer.parseInt(sHex, 16);
                    sDst.append(hHex);
                    i += 5;
                    continue;
                }
                catch (NumberFormatException e) {
                    assert (e != null);
                    continue;
                }
            }
            sDst.append(ch);
        }
        return sDst.toString();
    }

    private static boolean isCharAlphabetic(char cChar) {
        return Character.isLetter(cChar);
    }

    private static boolean isCharHexDigit(char cChar) {
        return Character.isDigit(cChar) || 'a' <= Character.toLowerCase(cChar) && Character.toLowerCase(cChar) <= 'f';
    }

    private static boolean isCharLiteral(char cChar) {
        return DateTimeUtil.matchChr(gsPictureLiterals, cChar);
    }

    private static boolean isCharNumeric(char cChar) {
        return cChar == '0' || cChar == '9';
    }

    private static boolean isCompoundPicture(String sPicture) {
        boolean bValid = true;
        int nCharIndex = 0;
        StringBuilder sCategory = new StringBuilder();
        StringBuilder sLoc = new StringBuilder();
        StringBuilder sMask = new StringBuilder();
        while (nCharIndex < sPicture.length()) {
            char cChar;
            int nPrevIndex = nCharIndex;
            if ((cChar = sPicture.charAt(nCharIndex++)) == '\'') {
                int nIndex = PictureFmt.getLiteralSubstr(sPicture, cChar, nCharIndex, null);
                if (nIndex > nCharIndex) {
                    nCharIndex = nIndex;
                    continue;
                }
                bValid = false;
                continue;
            }
            if (PictureFmt.isSubPicture(sPicture, nPrevIndex, sCategory, sLoc, sMask)) {
                if (sCategory.toString().startsWith(gsDate)) {
                    bValid = PictureFmt.isDatePicture(sMask.toString());
                } else if (sCategory.toString().startsWith(gsTime)) {
                    bValid = PictureFmt.isTimePicture(sMask.toString());
                } else if (sCategory.toString().equals(gsText)) {
                    bValid = PictureFmt.isTextPicture(sMask.toString());
                } else if (sCategory.toString().equals(gsNull)) {
                    bValid = PictureFmt.isNullPicture(sMask.toString());
                } else if (sCategory.toString().equals(gsZero)) {
                    bValid = PictureFmt.isZeroPicture(sMask.toString());
                } else if (sCategory.toString().equals(gsNum)) {
                    bValid = PictureFmt.isNumericPicture(sMask.toString());
                }
                if (!bValid) break;
                nPrevIndex += sCategory.length();
                if (sLoc.length() != 0) {
                    nPrevIndex += sLoc.length() + 2;
                }
                nCharIndex = nPrevIndex += sMask.length() + 2;
                continue;
            }
            if (PictureFmt.isCharNumeric(cChar) || PictureFmt.isCharLiteral(cChar)) continue;
            bValid = false;
            break;
        }
        return bValid;
    }

    public static boolean isDatePicture(String sPicture) {
        return PictureFmt.isPicture(sPicture, gsDate, "DJMEeYWwGgt");
    }

    public static boolean isDatePictureValid(String sPicture) {
        StringBuilder sCat = new StringBuilder();
        StringBuilder sLoc = new StringBuilder("en_US");
        StringBuilder sPict = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCat, sLoc, sPict) || !sCat.toString().equals(gsDate)) {
            sPict.replace(0, sPict.length(), sPicture);
        }
        LcDate today = new LcDate(1, sLoc.toString(), 30);
        return today.parse(today.format(sPict.toString()), sPict.toString());
    }

    public static boolean isDateTimePicture(String sPicture, StringBuilder sDateMask, StringBuilder sTimeMask) {
        assert (sDateMask != null);
        assert (sTimeMask != null);
        sDateMask.setLength(0);
        sTimeMask.setLength(0);
        int i = 0;
        while (i < sPicture.length()) {
            char cChar;
            StringBuilder sCategory = new StringBuilder();
            StringBuilder sLoc = new StringBuilder();
            StringBuilder sMask = new StringBuilder();
            int j = i;
            if ((cChar = sPicture.charAt(i++)) == '\'') {
                int k = PictureFmt.getLiteralSubstr(sPicture, cChar, i, null);
                if (k > i) {
                    i = k;
                    continue;
                }
            } else {
                if (PictureFmt.isCharLiteral(cChar) || cChar == 'T') continue;
                if (PictureFmt.isSubPicture(sPicture, j, sCategory, sLoc, sMask)) {
                    if (sCategory.toString().startsWith(gsDate) && PictureFmt.isDatePicture(sMask.toString())) {
                        j += sCategory.length();
                        if (sLoc.length() != 0) {
                            j += sLoc.length() + 2;
                        }
                        if (sCategory.indexOf(".") < 0) {
                            j += sMask.length();
                        }
                        j += 2;
                        sDateMask.append((CharSequence)sCategory);
                        if (sLoc.length() != 0) {
                            sDateMask.append('(');
                            sDateMask.append((CharSequence)sLoc);
                            sDateMask.append(')');
                        }
                        sDateMask.append('{');
                        if (sCategory.indexOf(".") < 0) {
                            sDateMask.append((CharSequence)sMask);
                        }
                        sDateMask.append('}');
                        i = j;
                        continue;
                    }
                    if (sCategory.toString().startsWith(gsTime) && PictureFmt.isTimePicture(sMask.toString())) {
                        j += sCategory.length();
                        if (sLoc.length() != 0) {
                            j += sLoc.length() + 2;
                        }
                        if (sCategory.indexOf(".") < 0) {
                            j += sMask.length();
                        }
                        j += 2;
                        sTimeMask.append((CharSequence)sCategory);
                        if (sLoc.length() != 0) {
                            sTimeMask.append('(');
                            sTimeMask.append((CharSequence)sLoc);
                            sTimeMask.append(')');
                        }
                        sTimeMask.append('{');
                        if (sCategory.indexOf(".") < 0) {
                            sTimeMask.append((CharSequence)sMask);
                        }
                        sTimeMask.append('}');
                        i = j;
                        continue;
                    }
                    if (sCategory.toString().startsWith(gsDateTime)) {
                        if (!PictureFmt.isDateTimePicture(sMask.toString(), sDateMask, sTimeMask)) {
                            return false;
                        }
                        i = j += sPicture.length();
                        continue;
                    }
                }
            }
            return false;
        }
        return sDateMask.length() != 0 && sTimeMask.length() != 0;
    }

    public static boolean isDateTimePictureValid(String sPicture) {
        LcTime now;
        LcDate today;
        StringBuilder sDatePict = new StringBuilder();
        StringBuilder sTimePict = new StringBuilder();
        if (!PictureFmt.isDateTimePicture(sPicture, sDatePict, sTimePict)) {
            return false;
        }
        StringBuilder sLoc = new StringBuilder("en_US");
        StringBuilder sCat = new StringBuilder();
        StringBuilder sPict = new StringBuilder();
        if (PictureFmt.hasSubPicture(sDatePict.toString(), 0, sCat, sLoc, sPict)) {
            sDatePict.replace(0, sDatePict.length(), sPict.toString());
        }
        if (!(today = new LcDate(1, sLoc.toString(), 30)).parse(today.format(sDatePict.toString()), sDatePict.toString())) {
            return false;
        }
        sLoc = new StringBuilder("en_US");
        sPict.setLength(0);
        sCat.setLength(0);
        if (PictureFmt.hasSubPicture(sTimePict.toString(), 0, sCat, sLoc, sPict)) {
            sTimePict.replace(0, sTimePict.length(), sPict.toString());
        }
        return (now = new LcTime(1, sLoc.toString())).parse(now.format(sTimePict.toString()), sTimePict.toString());
    }

    public static boolean isNullPicture(String sPicture) {
        StringBuilder sCat = new StringBuilder();
        StringBuilder sLoc = new StringBuilder();
        StringBuilder sMask = new StringBuilder();
        return PictureFmt.isSubPicture(sPicture, 0, sCat, sLoc, sMask) && sCat.toString().equals(gsNull);
    }

    public static boolean isEmptyPicture(String sPicture) {
        StringBuilder sCat = new StringBuilder();
        StringBuilder sLoc = new StringBuilder();
        StringBuilder sMask = new StringBuilder();
        return PictureFmt.isSubPicture(sPicture, 0, sCat, sLoc, sMask) && sMask.toString().length() == 0 && !sCat.toString().equals(gsNull) && !sCat.toString().equals(gsZero);
    }

    public static boolean isNullPictureValid(String sPicture) {
        StringBuilder sCat = new StringBuilder();
        StringBuilder sLoc = new StringBuilder("en_US");
        StringBuilder sPict = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCat, sLoc, sPict) || !sCat.toString().equals(gsNull)) {
            sPict.replace(0, sPict.length(), sPicture);
        }
        LcNum one = new LcNum("1", sLoc.toString());
        return one.parse(one.format(sPict.toString(), null), sPict.toString());
    }

    public static boolean isNumericPicture(String sPicture) {
        return PictureFmt.isPicture(sPicture, gsNum, "(%$,.)89BCDERSVZbcdrsvzt");
    }

    public static boolean isNumericPictureValid(String sPicture) {
        StringBuilder sCat = new StringBuilder();
        StringBuilder sLoc = new StringBuilder("en_US");
        StringBuilder sPict = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCat, sLoc, sPict) || !sCat.toString().equals(gsNum)) {
            sPict.replace(0, sPict.length(), sPicture);
        }
        StringBuilder sOne = new StringBuilder("1");
        int nDot = sPict.indexOf(".");
        if (nDot >= 0) {
            sOne.append('.');
            if (sPict.indexOf("8", nDot + 1) >= 0) {
                sOne.append('1');
            } else if (sPict.indexOf("z", nDot + 1) >= 0) {
                sOne.append('1');
            } else if (sPict.indexOf("Z", nDot + 1) >= 0) {
                sOne.append('1');
            }
            if (sPict.indexOf("%") >= 0) {
                sOne.replace(0, sOne.length(), ".001");
            }
        } else if (sPict.indexOf("%") >= 0) {
            sOne.replace(0, 1, ".00");
        }
        LcNum one = new LcNum(sOne.toString(), sLoc.toString());
        LcNum num = new LcNum(one.format(sPict.toString(), null), sPict.toString());
        return num.isValid();
    }

    private static boolean isPicture(String sPicture, String sCategory, String sSymbols) {
        StringBuilder sCat = new StringBuilder();
        StringBuilder sLoc = new StringBuilder();
        StringBuilder sMask = new StringBuilder();
        int i = 0;
        while (i < sPicture.length()) {
            char cChar;
            int j = i;
            if ((cChar = sPicture.charAt(i++)) == '\'') {
                int k = PictureFmt.getLiteralSubstr(sPicture, cChar, i, null);
                if (k > i) {
                    i = k;
                    continue;
                }
            } else {
                if (DateTimeUtil.matchChr(gsPictureLiterals, cChar)) continue;
                if (PictureFmt.isSubPicture(sPicture, j, sCat, sLoc, sMask) && sCat.toString().startsWith(sCategory)) {
                    String sCatStr = sCat.toString();
                    String sMaskStr = sMask.toString();
                    if (sCatStr.startsWith(gsNum) && PictureFmt.isNumericPicture(sMaskStr) || sCatStr.equals(gsNull) && PictureFmt.isNullPicture(sMaskStr) || sCatStr.equals(gsZero) && PictureFmt.isZeroPicture(sMaskStr) || sCatStr.equals(gsText) && PictureFmt.isTextPicture(sMaskStr) || sCatStr.startsWith(gsDate) && PictureFmt.isDatePicture(sMaskStr) || sCatStr.startsWith(gsTime) && PictureFmt.isTimePicture(sMaskStr)) {
                        j += sCat.length();
                        if (sLoc.length() != 0) {
                            j += sLoc.length() + 2;
                        }
                        i = j += sMask.length() + 2;
                        continue;
                    }
                } else if (DateTimeUtil.matchChr(sSymbols, cChar)) {
                    if (sSymbols != "(%$,.)89BCDERSVZbcdrsvzt") continue;
                    if (cChar == 'C' || cChar == 'c' || cChar == 'd' || cChar == 'D') {
                        if (i < sPicture.length()) {
                            char cNextChar = sPicture.charAt(i++);
                            if (!(cChar == 'C' && cNextChar != 'R' || cChar == 'c' && cNextChar != 'r' || cChar == 'd' && cNextChar != 'b') && (cChar != 'D' || cNextChar == 'B')) continue;
                            return false;
                        }
                        return false;
                    }
                    if (cChar != 'r' && cChar != 'R' && cChar != 'b' && cChar != 'B') continue;
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean isSubPicture(String sPicture, int nPictIndex, StringBuilder sCategory, StringBuilder sLocale, StringBuilder sSubMask) {
        String sSubCategory = "";
        sCategory.setLength(0);
        sSubMask.setLength(0);
        int nPrevIndex = nPictIndex;
        char cChar = sPicture.charAt(nPictIndex++);
        if (PictureFmt.isCharAlphabetic(cChar)) {
            int nLocaleEnd;
            int nCategoryBeg = nPrevIndex;
            if (nPictIndex == sPicture.length()) {
                return false;
            }
            nPrevIndex = nPictIndex;
            while (PictureFmt.isCharAlphabetic(sPicture.charAt(nPictIndex++))) {
                nPrevIndex = nPictIndex;
                if (nPictIndex != sPicture.length()) continue;
                return false;
            }
            int nCategoryEnd = nPrevIndex;
            int nLocaleBeg = nLocaleEnd = nPictIndex;
            nPictIndex = nPrevIndex;
            if ((cChar = sPicture.charAt(nPictIndex++)) == '.') {
                int nSubCategoryBeg = nPictIndex;
                if (nPictIndex == sPicture.length()) {
                    return false;
                }
                nPrevIndex = nPictIndex;
                while ((cChar = sPicture.charAt(nPictIndex++)) != '(' && cChar != '{') {
                    nPrevIndex = nPictIndex;
                    if (nPictIndex != sPicture.length()) continue;
                    return false;
                }
                int nSubCategoryEnd = nPrevIndex;
                sSubCategory = sPicture.substring(nSubCategoryBeg, nSubCategoryEnd);
            }
            if (cChar == '(') {
                nLocaleBeg = nPictIndex;
                if (nPictIndex == sPicture.length()) {
                    return false;
                }
                nPrevIndex = nPictIndex;
                while (sPicture.charAt(nPictIndex++) != ')') {
                    nPrevIndex = nPictIndex;
                    if (nPictIndex != sPicture.length()) continue;
                    return false;
                }
                nLocaleEnd = nPrevIndex;
                cChar = sPicture.charAt(nPictIndex++);
            }
            if (cChar == '{') {
                int nSubMaskBeg = nPictIndex;
                while (true) {
                    if (nPictIndex == sPicture.length()) {
                        return false;
                    }
                    nPrevIndex = nPictIndex;
                    if ((cChar = sPicture.charAt(nPictIndex++)) == '\'') {
                        int nIndex = PictureFmt.getLiteralSubstr(sPicture, cChar, nPictIndex, null);
                        if (nIndex == nPictIndex) {
                            return false;
                        }
                        nPictIndex = nIndex;
                        continue;
                    }
                    if (cChar == '}') break;
                }
                int nSubMaskEnd = nPrevIndex;
                String sCandidate = sPicture.substring(nCategoryBeg, nCategoryEnd);
                if (sCandidate.equals(gsNull) || sCandidate.equals(gsZero) || sCandidate.equals(gsText)) {
                    sCategory.replace(0, sCategory.length(), sCandidate);
                    if (nLocaleEnd > nLocaleBeg) {
                        sLocale.replace(0, sLocale.length(), sPicture.substring(nLocaleBeg, nLocaleEnd));
                    }
                    sSubMask.replace(0, sSubMask.length(), sPicture.substring(nSubMaskBeg, nSubMaskEnd));
                    return true;
                }
                if (sCandidate.equals(gsDate) || sCandidate.equals(gsTime)) {
                    sCategory.replace(0, sCategory.length(), sCandidate);
                    if (nLocaleEnd > nLocaleBeg) {
                        sLocale.replace(0, sLocale.length(), sPicture.substring(nLocaleBeg, nLocaleEnd));
                    }
                    String sLoc = "en_US";
                    if (sLocale.length() != 0) {
                        sLoc = sLocale.toString();
                    }
                    String sFmt = null;
                    if (sSubCategory.length() == 0) {
                        sFmt = sPicture.substring(nSubMaskBeg, nSubMaskEnd);
                    } else if (sSubCategory.equals(gsShort)) {
                        LcData oData = new LcData(sLoc);
                        sFmt = sCandidate.equals(gsDate) ? oData.getDateFormat(1) : oData.getTimeFormat(1);
                    } else if (sSubCategory.equals(gsMedium)) {
                        LcData oData = new LcData(sLoc);
                        sFmt = sCandidate.equals(gsDate) ? oData.getDateFormat(2) : oData.getTimeFormat(2);
                    } else if (sSubCategory.equals(gsLong)) {
                        LcData oData = new LcData(sLoc);
                        sFmt = sCandidate.equals(gsDate) ? oData.getDateFormat(3) : oData.getTimeFormat(3);
                    } else if (sSubCategory.equals(gsFull)) {
                        LcData oData = new LcData(sLoc);
                        sFmt = sCandidate.equals(gsDate) ? oData.getDateFormat(4) : oData.getTimeFormat(4);
                    } else if (sSubCategory.equals(gsDefault)) {
                        LcData oData = new LcData(sLoc);
                        sFmt = sCandidate.equals(gsDate) ? oData.getDateFormat(0) : oData.getTimeFormat(0);
                    } else {
                        return false;
                    }
                    sSubMask.replace(0, sSubMask.length(), sFmt);
                    if (sSubCategory.length() != 0) {
                        sCategory.append('.');
                        sCategory.append(sSubCategory);
                    }
                    return true;
                }
                if (sCandidate.equals(gsNum)) {
                    sCategory.replace(0, sCategory.length(), sCandidate);
                    if (nLocaleEnd > nLocaleBeg) {
                        sLocale.replace(0, sLocale.length(), sPicture.substring(nLocaleBeg, nLocaleEnd));
                    }
                    String sLoc = "en_US";
                    if (sLocale.length() != 0) {
                        sLoc = sLocale.toString();
                    }
                    String sFmt = null;
                    if (sSubCategory.length() == 0) {
                        sFmt = sPicture.substring(nSubMaskBeg, nSubMaskEnd);
                    } else if (sSubCategory.equals(gsInteger)) {
                        LcData oData = new LcData(sLoc);
                        int nOptn = 1;
                        sFmt = oData.getNumberFormat(0, nOptn);
                    } else if (sSubCategory.equals(gsDecimal)) {
                        LcData oData = new LcData(sLoc);
                        int nOptn = LcData.withPrecision(-1) | 1;
                        sFmt = oData.getNumberFormat(1, nOptn);
                    } else if (sSubCategory.equals(gsCurrency)) {
                        LcData oData = new LcData(sLoc);
                        int nOptn = LcData.withPrecision(-1) | 1;
                        sFmt = oData.getNumberFormat(2, nOptn);
                    } else if (sSubCategory.equals(gsPercent)) {
                        LcData oData = new LcData(sLoc);
                        int nOptn = 1;
                        sFmt = oData.getNumberFormat(3, nOptn);
                    } else {
                        return false;
                    }
                    sSubMask.replace(0, sSubMask.length(), sFmt);
                    if (sSubCategory.length() != 0) {
                        sCategory.append('.');
                        sCategory.append(sSubCategory);
                    }
                    return true;
                }
                if (sCandidate.equals(gsDateTime)) {
                    int nCurly;
                    sCategory.replace(0, sCategory.length(), sCandidate);
                    if (nLocaleEnd > nLocaleBeg) {
                        sLocale.replace(0, sLocale.length(), sPicture.substring(nLocaleBeg, nLocaleEnd));
                    }
                    String sLoc = "en_US";
                    if (sLocale.length() != 0) {
                        sLoc = sLocale.toString();
                    }
                    String sFmt = null;
                    LcData oData = new LcData(sLoc);
                    int nOptn = 1;
                    if (sSubCategory.equals(gsShort)) {
                        sFmt = oData.getDateTimeFormat(1, nOptn);
                    } else if (sSubCategory.equals(gsMedium)) {
                        sFmt = oData.getDateTimeFormat(2, nOptn);
                    } else if (sSubCategory.equals(gsLong)) {
                        sFmt = oData.getDateTimeFormat(3, nOptn);
                    } else if (sSubCategory.equals(gsFull)) {
                        sFmt = oData.getDateTimeFormat(4, nOptn);
                    } else if (sSubCategory.equals(gsDefault)) {
                        sFmt = oData.getDateTimeFormat(0, nOptn);
                    } else {
                        return false;
                    }
                    sSubMask.replace(0, sSubMask.length(), sFmt);
                    if (sSubCategory.length() != 0) {
                        sCategory.append('.');
                        sCategory.append(sSubCategory);
                    }
                    if ((nCurly = sSubMask.indexOf("date{")) >= 0) {
                        sSubMask.insert(nCurly += 4, ')');
                        sSubMask.insert(nCurly, sLoc);
                        sSubMask.insert(nCurly, '(');
                    }
                    if ((nCurly = sSubMask.indexOf("time{")) >= 0) {
                        sSubMask.insert(nCurly += 4, ')');
                        sSubMask.insert(nCurly, sLoc);
                        sSubMask.insert(nCurly, '(');
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isTextPicture(String sPicture) {
        return PictureFmt.isPicture(sPicture, gsText, "9AO0Xt");
    }

    public static boolean isTextPictureValid(String sPicture) {
        StringBuilder sCat = new StringBuilder();
        StringBuilder sLoc = new StringBuilder("en_US");
        StringBuilder sPict = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCat, sLoc, sPict) || !sCat.toString().equals(gsText)) {
            sPict.replace(0, sPict.length(), sPicture);
        }
        return true;
    }

    public static boolean isTimePicture(String sPicture) {
        return PictureFmt.isPicture(sPicture, gsTime, "hkHKMSFAZzt");
    }

    public static boolean isTimePictureValid(String sPicture) {
        StringBuilder sCat = new StringBuilder();
        StringBuilder sLoc = new StringBuilder("en_US");
        StringBuilder sPict = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCat, sLoc, sPict) || !sCat.toString().equals(gsTime)) {
            sPict.replace(0, sPict.length(), sPicture);
        }
        LcTime now = new LcTime(1, sLoc.toString());
        return now.parse(now.format(sPict.toString()), sPict.toString());
    }

    public static boolean isZeroPicture(String sPicture) {
        StringBuilder sCat = new StringBuilder();
        StringBuilder sLoc = new StringBuilder();
        StringBuilder sMask = new StringBuilder();
        return PictureFmt.isSubPicture(sPicture, 0, sCat, sLoc, sMask) && sCat.toString().equals(gsZero);
    }

    public static boolean isZeroPictureValid(String sPicture) {
        StringBuilder sCat = new StringBuilder();
        StringBuilder sLoc = new StringBuilder("en_US");
        StringBuilder sPict = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCat, sLoc, sPict) || !sCat.toString().equals(gsZero)) {
            sPict.replace(0, sPict.length(), sPicture);
        }
        LcNum one = new LcNum("1", sLoc.toString());
        return one.parse(one.format(sPict.toString(), null), sPict.toString());
    }

    public static boolean parseCompound(String sSource, String sPicture, String sLocale, StringHolder sResult) {
        MsgFormatPos oMessage = new MsgFormatPos(ResId.UNSUPPORTED_OPERATION, "PictureFmt#parseCompound");
        oMessage.format("parseCompound");
        throw new ExFull(oMessage);
    }

    public static boolean parseDate(String sSource, String sPicture, String sLocale, StringHolder sResult, boolean bAsLocal) {
        LcDate oDate;
        StringBuilder sDateMask;
        StringBuilder sLoc;
        StringBuilder sCategory;
        if (!StringUtils.isEmpty(sResult.value)) {
            sResult.value = "";
        }
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCategory = new StringBuilder(), sLoc = new StringBuilder(sLocale), sDateMask = new StringBuilder()) && !sCategory.toString().equals(gsDate)) {
            sDateMask.replace(0, sDateMask.length(), sPicture);
        }
        if ((oDate = new LcDate(sSource, sDateMask.toString(), sLoc.toString(), 30)).isValid()) {
            ISODate oISODate = new ISODate(oDate.getDays());
            if (bAsLocal) {
                oISODate.setLocalDate();
            }
            sResult.value = oISODate.format("YYYY-MM-DD");
        }
        return !StringUtils.isEmpty(sResult.value);
    }

    public static boolean parseDateTime(String sSource, String sPicture, String sDateMask, String sTimeMask, String sLocale, StringHolder sResult, boolean bAsLocal) {
        int nAt;
        int nInfixSourceStart;
        String sPostfixMask;
        String sInfixMask;
        String sPrefixMask;
        Point p;
        boolean bDateFirst = false;
        int nDateFound = sPicture.indexOf(sDateMask);
        assert (nDateFound >= 0);
        int nTimeFound = sPicture.indexOf(sTimeMask);
        assert (nTimeFound >= 0);
        boolean bl = bDateFirst = nDateFound < nTimeFound;
        if (bDateFirst) {
            p = PictureFmt.resolveRange(sPicture, 0, nDateFound);
            sPrefixMask = sPicture.substring(p.x, p.y);
            p = PictureFmt.resolveRange(sPicture, nDateFound + sDateMask.length(), nTimeFound);
            sInfixMask = sPicture.substring(p.x, p.y);
            p = PictureFmt.resolveRange(sPicture, nTimeFound + sTimeMask.length(), sPicture.length());
            sPostfixMask = sPicture.substring(p.x, p.y);
        } else {
            p = PictureFmt.resolveRange(sPicture, 0, nTimeFound);
            sPrefixMask = sPicture.substring(p.x, p.y);
            p = PictureFmt.resolveRange(sPicture, nTimeFound + sTimeMask.length(), nDateFound);
            sInfixMask = sPicture.substring(p.x, p.y);
            p = PictureFmt.resolveRange(sPicture, nDateFound + sDateMask.length(), sPicture.length());
            sPostfixMask = sPicture.substring(p.x, p.y);
        }
        LcDate oPrefixData = new LcDate(sLocale, 30);
        String sPrefixMaskData = oPrefixData.format(sPrefixMask);
        LcDate oInfixData = new LcDate(sLocale, 30);
        String sInfixMaskData = oInfixData.format(sInfixMask);
        LcDate oPostfixData = new LcDate(sLocale, 30);
        String sPostfixMaskData = oPostfixData.format(sPostfixMask);
        int nInfixFound = 0;
        if (sInfixMaskData.length() != 0) {
            int nAt2;
            int nStart = 0;
            while ((nAt2 = sSource.indexOf(sInfixMaskData, nStart)) >= 0) {
                nInfixSourceStart = nAt2;
                nStart = nAt2 + sInfixMaskData.length();
                ++nInfixFound;
            }
        }
        if (nInfixFound == 0) {
            int nPostfixSourceStart;
            int nTimeSourceStart;
            int nDateSourceStart;
            StringBuilder sLoc = new StringBuilder(sLocale);
            StringBuilder sCategory = new StringBuilder();
            StringBuilder sDateSubMask = new StringBuilder();
            StringBuilder sTimeSubMask = new StringBuilder();
            PictureFmt.isSubPicture(sDateMask, 0, sCategory, sLoc, sDateSubMask);
            LcDate oToday = new LcDate(1, sLoc.toString(), 30);
            String sDateMaskData = oToday.format(sDateSubMask.toString());
            sLoc.replace(0, sLoc.length(), sLocale);
            PictureFmt.isSubPicture(sTimeMask, 0, sCategory, sLoc, sTimeSubMask);
            LcTime oNow = new LcTime(3661001, sLoc.toString());
            String sTimeMaskData = oNow.format(sTimeSubMask.toString());
            if (bDateFirst) {
                nDateSourceStart = sPrefixMaskData.length();
                nInfixSourceStart = nDateSourceStart + sDateMaskData.length();
                nTimeSourceStart = nInfixSourceStart + sInfixMaskData.length();
                nPostfixSourceStart = nTimeSourceStart + sTimeMaskData.length();
            } else {
                nTimeSourceStart = sPrefixMaskData.length();
                nInfixSourceStart = nTimeSourceStart + sTimeMaskData.length();
                nDateSourceStart = nInfixSourceStart + sInfixMaskData.length();
                nPostfixSourceStart = nDateSourceStart + sDateMaskData.length();
            }
            Point p2 = PictureFmt.resolveRange(sSource, 0, sPrefixMaskData.length());
            String sPrefixSource = sSource.substring(p2.x, p2.y);
            p2 = PictureFmt.resolveRange(sSource, nDateSourceStart, nDateSourceStart + sDateMaskData.length());
            String sDateSource = sSource.substring(p2.x, p2.y);
            p2 = PictureFmt.resolveRange(sSource, nInfixSourceStart, nInfixSourceStart + sInfixMaskData.length());
            String sInfixSource = sSource.substring(p2.x, p2.y);
            p2 = PictureFmt.resolveRange(sSource, nTimeSourceStart, nTimeSourceStart + sTimeMaskData.length());
            String sTimeSource = sSource.substring(p2.x, p2.y);
            p2 = PictureFmt.resolveRange(sSource, nPostfixSourceStart, sSource.length());
            String sPostfixSource = sSource.substring(p2.x, p2.y);
            if (!sPrefixSource.equals(sPrefixMaskData)) {
                return false;
            }
            if (!sPostfixSource.equals(sPostfixMaskData)) {
                return false;
            }
            if (!sInfixSource.equals(sInfixMaskData)) {
                return false;
            }
            StringHolder sParsedDate = new StringHolder();
            if (!PictureFmt.parseDate(sDateSource, sDateMask, sLocale, sParsedDate, bAsLocal)) {
                return false;
            }
            StringHolder sParsedTime = new StringHolder();
            if (!PictureFmt.parseTime(sTimeSource, sTimeMask, sLocale, sParsedTime, bAsLocal)) {
                return false;
            }
            sResult.value = sParsedDate.value + 'T' + sParsedTime.value;
            return true;
        }
        int nStart = 0;
        while ((nAt = sSource.indexOf(sInfixMaskData, nStart)) >= 0) {
            StringHolder sParsedTime;
            StringHolder sParsedDate;
            String sTimeSource;
            int nTimeSourceStart;
            String sDateSource;
            Point p3;
            int nDateSourceStart;
            nInfixSourceStart = nAt;
            int nPostfixSourceStart = sSource.length() - sPostfixMaskData.length();
            if (bDateFirst) {
                nDateSourceStart = sPrefixMaskData.length();
                p3 = PictureFmt.resolveRange(sSource, nDateSourceStart, nInfixSourceStart);
                sDateSource = sSource.substring(p3.x, p3.y);
                nTimeSourceStart = nInfixSourceStart + sInfixMaskData.length();
                p3 = PictureFmt.resolveRange(sSource, nTimeSourceStart, nPostfixSourceStart);
                sTimeSource = sSource.substring(p3.x, p3.y);
            } else {
                nTimeSourceStart = sPrefixMaskData.length();
                p3 = PictureFmt.resolveRange(sSource, nTimeSourceStart, nInfixSourceStart);
                sTimeSource = sSource.substring(p3.x, p3.y);
                nDateSourceStart = nInfixSourceStart + sInfixMaskData.length();
                p3 = PictureFmt.resolveRange(sSource, nDateSourceStart, nPostfixSourceStart);
                sDateSource = sSource.substring(p3.x, p3.y);
            }
            p3 = PictureFmt.resolveRange(sSource, 0, sPrefixMaskData.length());
            String sPrefixSource = sSource.substring(p3.x, p3.y);
            p3 = PictureFmt.resolveRange(sSource, nInfixSourceStart, nInfixSourceStart + sInfixMaskData.length());
            String sInfixSource = sSource.substring(p3.x, p3.y);
            p3 = PictureFmt.resolveRange(sSource, nPostfixSourceStart, sSource.length());
            String sPostfixSource = sSource.substring(p3.x, p3.y);
            if (sPrefixSource.equals(sPrefixMaskData) && sPostfixSource.equals(sPostfixMaskData) && sInfixSource.equals(sInfixMaskData) && PictureFmt.parseDate(sDateSource, sDateMask, sLocale, sParsedDate = new StringHolder(), bAsLocal) && PictureFmt.parseTime(sTimeSource, sTimeMask, sLocale, sParsedTime = new StringHolder(), bAsLocal)) {
                sResult.value = sParsedDate.value + 'T' + sParsedTime.value;
                return true;
            }
            nStart = nAt + sInfixMaskData.length();
        }
        return false;
    }

    public static boolean parseNull(String sSource, String sPicture, String sLocale, StringHolder sResult) {
        LcNum oNum;
        sResult.value = "";
        StringBuilder sCategory = new StringBuilder();
        StringBuilder sLoc = new StringBuilder(sLocale);
        StringBuilder sNullMask = new StringBuilder();
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCategory, sLoc, sNullMask) && !sCategory.toString().equals(gsNull)) {
            sNullMask.replace(0, sNullMask.length(), sPicture);
        }
        if ((oNum = new LcNum(sSource, sNullMask.toString(), sLoc.toString())).isValid()) {
            sResult.value = null;
        }
        return sResult.value == null;
    }

    public static boolean parseNumeric(String sSource, String sPicture, String sLocale, StringHolder sResult) {
        LcNum oNum;
        StringBuilder sNumMask;
        StringBuilder sLoc;
        StringBuilder sCategory;
        if (!StringUtils.isEmpty(sResult.value)) {
            sResult.value = "";
        }
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCategory = new StringBuilder(), sLoc = new StringBuilder(sLocale), sNumMask = new StringBuilder()) && !sCategory.toString().equals(gsNum)) {
            sNumMask.replace(0, sNumMask.length(), sPicture);
        }
        if ((oNum = new LcNum(sSource, sNumMask.toString(), sLoc.toString())).isValid()) {
            sResult.value = oNum.getText();
        }
        return !StringUtils.isEmpty(sResult.value);
    }

    public static boolean parseText(String sSource, String sPicture, String sLocale, StringHolder sResult) {
        LcText oText;
        StringBuilder sTextMask;
        StringBuilder sLoc;
        StringBuilder sCategory;
        if (!StringUtils.isEmpty(sResult.value)) {
            sResult.value = "";
        }
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCategory = new StringBuilder(), sLoc = new StringBuilder(sLocale), sTextMask = new StringBuilder()) && !sCategory.toString().equals(gsText)) {
            sTextMask.replace(0, sTextMask.length(), sPicture);
        }
        if ((oText = new LcText(sSource, sTextMask.toString(), sLoc.toString())).isValid()) {
            sResult.value = oText.getText();
        }
        return !StringUtils.isEmpty(sResult.value);
    }

    public static boolean parseTime(String sSource, String sPicture, String sLocale, StringHolder sResult, boolean bAsLocal) {
        LcTime oTime;
        StringBuilder sTimeMask;
        StringBuilder sLoc;
        StringBuilder sCategory;
        if (!StringUtils.isEmpty(sResult.value)) {
            sResult.value = "";
        }
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCategory = new StringBuilder(), sLoc = new StringBuilder(sLocale), sTimeMask = new StringBuilder()) && !sCategory.toString().equals(gsTime)) {
            sTimeMask.replace(0, sTimeMask.length(), sPicture);
        }
        if ((oTime = new LcTime(sSource, sTimeMask.toString(), sLoc.toString())).isValid()) {
            ISOTime oISOTime = new ISOTime(oTime.getMillis());
            if (bAsLocal) {
                oISOTime.setLocalTime();
            }
            sResult.value = oISOTime.getMilliSecond() > 0 ? oISOTime.format("HH:MM:SS.FFF") : (oISOTime.getSecond() > 0 ? oISOTime.format("HH:MM:SS") : (oISOTime.getMinute() > 0 ? oISOTime.format("HH:MM") : oISOTime.format("HH")));
        }
        return !StringUtils.isEmpty(sResult.value);
    }

    public static boolean parseZero(String sSource, String sPicture, String sLocale, StringHolder sResult) {
        LcNum oNum;
        StringBuilder sZeroMask;
        StringBuilder sLoc;
        StringBuilder sCategory;
        if (!StringUtils.isEmpty(sResult.value)) {
            sResult.value = "";
        }
        if (!PictureFmt.hasSubPicture(sPicture, 0, sCategory = new StringBuilder(), sLoc = new StringBuilder(sLocale), sZeroMask = new StringBuilder()) && !sCategory.toString().equals(gsZero)) {
            sZeroMask.replace(0, sZeroMask.length(), sPicture);
        }
        if ((oNum = new LcNum(sSource, sZeroMask.toString(), sLoc.toString())).isValid() && oNum.getValue() == 0.0) {
            sResult.value = "0";
        }
        return !StringUtils.isEmpty(sResult.value);
    }

    private static int getLiteralSubstr(String sPicture, char cChar, int nCharPos, StringBuilder sLiteral) {
        assert (cChar == '\'');
        int nFoundPos = nCharPos;
        int nPos = 0;
        int nQuoteBeg = nCharPos;
        int nQuoteEnd = sPicture.length() - 1;
        int nStart = nPos = nCharPos;
        while ((nPos = sPicture.indexOf(cChar, nStart)) >= 0 && nPos + 1 != sPicture.length() && sPicture.charAt(nPos + 1) == cChar) {
            nStart = nPos + 2;
        }
        if (nPos > nCharPos) {
            nQuoteEnd = nPos;
            nFoundPos = nPos + 1;
            if (sLiteral != null) {
                sLiteral.append(sPicture, nQuoteBeg, nQuoteEnd);
            }
        }
        return nFoundPos;
    }
}

