/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import com.adobe.granite.toggle.api.ToggleRouter;
import com.day.cq.commons.Language;
import com.ibm.icu.lang.UScript;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class LanguageUtil {
    public static final Set<String> ISO_LANGUAGES;
    private static final Set<String> NON_STANDARD_LANGUAGE_CODES;
    public static final Set<String> ISO_COUNTRIES;
    private static final Set<String> ISO_SCRIPTS;
    static final String SCRIPT_TOGGLE = "FT_CQ-4332753";
    public static final String PSEUDO_LANGUAGE = "zz";
    private static final Pattern SINGLE_CODE;
    private static final Pattern LANGUAGE_AND_COUNTRY;
    private static final Pattern LANGUAGE_SCRIPT_COUNTRY;
    private static ToggleRouter toggleRouter;

    public static Locale getLocale(String code) {
        Language l = LanguageUtil.getLanguage(code);
        return l == null ? null : l.getLocale();
    }

    public static Language getLanguage(String code) {
        if (code == null) {
            return null;
        }
        code = code.replaceAll("-", "_");
        if (toggleRouter != null && !toggleRouter.isEnabled(SCRIPT_TOGGLE)) {
            String lang = null;
            String country = "";
            if (code.length() == 2) {
                lang = code.toLowerCase();
            } else if (code.length() == 5 && code.charAt(2) == '_') {
                lang = code.substring(0, 2);
                country = code.substring(3);
            }
            if (lang == null) {
                return null;
            }
            if (!(PSEUDO_LANGUAGE.equalsIgnoreCase(lang) || ISO_LANGUAGES.contains(lang.toLowerCase()) || NON_STANDARD_LANGUAGE_CODES.contains(lang.toLowerCase()))) {
                return null;
            }
            if (!(country.length() <= 0 || ISO_COUNTRIES.contains(country.toUpperCase()) || NON_STANDARD_LANGUAGE_CODES.contains(country.toUpperCase()) || PSEUDO_LANGUAGE.equalsIgnoreCase(lang))) {
                return null;
            }
            return new Language(lang, country);
        }
        String lang = null;
        String country = "";
        String script = "";
        if (code.length() == 2) {
            lang = code.toLowerCase();
        } else if (code.length() == 5 && code.charAt(2) == '_') {
            lang = code.substring(0, 2);
            country = code.substring(3);
        } else if (code.length() == 7 && code.charAt(2) == '_') {
            lang = code.substring(0, 2);
            script = code.substring(3);
        } else if (code.length() == 10 && code.charAt(2) == '_' && code.charAt(7) == '_') {
            lang = code.substring(0, 2);
            script = code.substring(3, 7);
            country = code.substring(8);
        }
        if (lang == null) {
            return null;
        }
        if (!(PSEUDO_LANGUAGE.equalsIgnoreCase(lang) || ISO_LANGUAGES.contains(lang.toLowerCase()) || NON_STANDARD_LANGUAGE_CODES.contains(lang.toLowerCase()))) {
            return null;
        }
        if (!(country.length() <= 0 || ISO_COUNTRIES.contains(country.toUpperCase()) || NON_STANDARD_LANGUAGE_CODES.contains(country.toUpperCase()) || PSEUDO_LANGUAGE.equalsIgnoreCase(lang))) {
            return null;
        }
        if (script.length() == 0) {
            return new Language(lang, country);
        }
        if (!LanguageUtil.isScriptTag(script)) {
            return null;
        }
        try {
            Locale locale = new Locale.Builder().setLanguage(lang).setRegion(country).setScript(script).build();
            return new Language(locale);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static String getLanguageRoot(String path) {
        String strTempPrefix;
        String code;
        if (path == null || path.length() == 0 || path.equals("/")) {
            return null;
        }
        String root = null;
        String strPrefix = "";
        String strTempPath = path;
        if (toggleRouter != null && toggleRouter.isEnabled(SCRIPT_TOGGLE)) {
            Matcher tm = LANGUAGE_SCRIPT_COUNTRY.matcher(path);
            while (tm.find() && root == null) {
                code = tm.group(1);
                if (LanguageUtil.getLocale(code) != null) {
                    root = strPrefix + strTempPath.substring(0, tm.end(1));
                }
                strTempPrefix = strTempPath.substring(0, tm.end(1));
                strPrefix = strPrefix + strTempPrefix;
                strTempPath = strTempPath.substring(strTempPrefix.length());
                tm = LANGUAGE_SCRIPT_COUNTRY.matcher(strTempPath);
            }
        }
        if (root == null) {
            strPrefix = "";
            strTempPath = path;
            Matcher m = LANGUAGE_AND_COUNTRY.matcher(path);
            while (m.find() && root == null) {
                code = m.group(1);
                if (LanguageUtil.getLocale(code) != null) {
                    root = strPrefix + strTempPath.substring(0, m.end(1));
                }
                strTempPrefix = strTempPath.substring(0, m.end(1));
                strPrefix = strPrefix + strTempPrefix;
                strTempPath = strTempPath.substring(strTempPrefix.length());
                m = LANGUAGE_AND_COUNTRY.matcher(strTempPath);
            }
        }
        if (root == null) {
            int pos = -1;
            String last = null;
            Matcher sm = SINGLE_CODE.matcher(path);
            while (sm.find()) {
                String code2 = sm.group(1);
                if (last == null && LanguageUtil.getLocale(code2) != null) {
                    last = code2;
                    pos = sm.end(1);
                } else if (last != null && LanguageUtil.getLocale(code2 + "_" + last) != null) {
                    pos = sm.end(1);
                    break;
                }
                sm.region(sm.end(1), path.length());
            }
            if (pos > 0) {
                root = path.substring(0, pos);
            }
        }
        return root;
    }

    static boolean isScriptTag(String code) {
        if (code.length() == 4) {
            return ISO_SCRIPTS.contains(code.toLowerCase());
        }
        return false;
    }

    static boolean isLanguageCode(String code) {
        return ISO_LANGUAGES.contains(code.toLowerCase());
    }

    static boolean isCountryCode(String code) {
        return ISO_COUNTRIES.contains(code.toUpperCase());
    }

    static {
        ServiceReference serviceReference;
        BundleContext bundleContext;
        ISO_LANGUAGES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Locale.getISOLanguages())));
        NON_STANDARD_LANGUAGE_CODES = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("tc")));
        ISO_COUNTRIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Locale.getISOCountries())));
        ISO_SCRIPTS = Collections.unmodifiableSet(IntStream.range(0, 200).mapToObj(i -> UScript.getShortName((int)i)).filter(code -> code != null).map(String::toLowerCase).collect(Collectors.toSet()));
        SINGLE_CODE = Pattern.compile("/([a-zA-Z]{2})(/|$)");
        LANGUAGE_AND_COUNTRY = Pattern.compile("/([a-zA-Z]{2,3}[_-][a-zA-Z]{2,3})(/|$)");
        LANGUAGE_SCRIPT_COUNTRY = Pattern.compile("/([a-zA-Z]{2}[_-][a-zA-Z]{4}([_-][a-zA-Z]{2}){0,1})(/|$)");
        Bundle bundle = FrameworkUtil.getBundle(LanguageUtil.class);
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null && (serviceReference = bundleContext.getServiceReference(ToggleRouter.class.getName())) != null) {
            toggleRouter = (ToggleRouter)bundleContext.getService(serviceReference);
        }
    }
}

