/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.contentsync.handler;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.contentsync.handler.AbstractDefaultContentUpdateHandler;
import com.day.cq.contentsync.handler.ContentUpdateHandler;
import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import com.day.cq.contentsync.impl.handler.util.RequestResponseFactoryImpl;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.engine.SlingRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, componentAbstract=true)
public abstract class AbstractSlingResourceUpdateHandler
extends AbstractDefaultContentUpdateHandler
implements ContentUpdateHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractSlingResourceUpdateHandler.class);
    @Reference
    protected SlingRequestProcessor slingServlet;
    @Reference
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference
    protected RequestResponseFactory requestResponseFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean renderResource(String uri, String configCacheRoot, Session admin, Session session) throws RepositoryException, ServletException, IOException, NoSuchAlgorithmException {
        String cachePath = configCacheRoot + this.getTargetPath(uri);
        DeferredFileOutputStream out = new DeferredFileOutputStream(65536, "content-sync", ".tmp", null);
        boolean isHashMatched = false;
        try {
            String hash;
            ResourceResolver resolver = this.resourceResolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", session));
            HttpServletRequest request = this.createRequest(uri);
            HttpServletResponse response = ((RequestResponseFactoryImpl)this.requestResponseFactory).createBufferedResponse((OutputStream)out);
            this.slingServlet.processRequest(request, response, resolver);
            response.getWriter().flush();
            InputStream inputStream = null;
            try {
                inputStream = out.isInMemory() ? new ByteArrayInputStream(out.getData()) : new FileInputStream(out.getFile());
                hash = DigestUtils.sha256Hex(inputStream);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(inputStream);
            isHashMatched = this.hashMatches(session, cachePath, hash);
            if (!isHashMatched) {
                log.debug("Hash missing or not equal, updating content sync cache: {}", (Object)cachePath);
                JcrUtil.createPath(cachePath, "sling:Folder", "nt:file", admin, false);
                Node cacheContentNode = JcrUtil.createPath(cachePath + "/" + "jcr:content", "nt:resource", admin);
                if (out.isInMemory()) {
                    cacheContentNode.setProperty("jcr:data", admin.getValueFactory().createBinary(new ByteArrayInputStream(out.getData())));
                } else {
                    cacheContentNode.setProperty("jcr:data", admin.getValueFactory().createBinary(new FileInputStream(out.getFile())));
                }
                cacheContentNode.setProperty("jcr:lastModified", Calendar.getInstance());
                if (response.getContentType() != null) {
                    cacheContentNode.setProperty("jcr:mimeType", response.getContentType());
                }
                if (response.getCharacterEncoding() != null) {
                    cacheContentNode.setProperty("jcr:encoding", response.getCharacterEncoding());
                }
                this.writeHash(cacheContentNode, hash);
                admin.save();
                boolean bl = true;
                return bl;
            }
            log.debug("Skipping update of content sync cache: {}", (Object)uri);
            boolean bl = false;
            return bl;
        }
        catch (LoginException e) {
            log.error("Creating resource resolver for resource rendering failed: ", e);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(out);
            if (!isHashMatched && admin.hasPendingChanges()) {
                admin.refresh(false);
            }
        }
    }

    protected HttpServletRequest createRequest(String uri) {
        return this.requestResponseFactory.createRequest("GET", uri);
    }

    protected String getTargetPath(String path) {
        return path;
    }

    protected void bindSlingServlet(SlingRequestProcessor slingRequestProcessor) {
        this.slingServlet = slingRequestProcessor;
    }

    protected void unbindSlingServlet(SlingRequestProcessor slingRequestProcessor) {
        if (this.slingServlet == slingRequestProcessor) {
            this.slingServlet = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindRequestResponseFactory(RequestResponseFactory requestResponseFactory) {
        this.requestResponseFactory = requestResponseFactory;
    }

    protected void unbindRequestResponseFactory(RequestResponseFactory requestResponseFactory) {
        if (this.requestResponseFactory == requestResponseFactory) {
            this.requestResponseFactory = null;
        }
    }
}

