/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathToIDValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PathToIDValidator.class);

    public static Map<String, String> getActualPaths(Session session, String[] paths, String[] ids) {
        if (paths == null) {
            throw new IllegalStateException("Paths must not be null");
        }
        if (ids == null) {
            throw new IllegalStateException("Ids must not be null");
        }
        if (paths.length != ids.length) {
            String joiner = new StringJoiner(" ").add("Length Mismatch:  Paths:").add(String.valueOf(paths.length)).add("ids:").add(String.valueOf(ids.length)).toString();
            throw new IllegalStateException(joiner);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (int i = 0; i < paths.length; ++i) {
            result.put(paths[i], PathToIDValidator.getActualPath(session, paths[i], ids[i]));
        }
        return result;
    }

    public static String getActualPath(Session session, String path, String id) {
        try {
            if (session.nodeExists(path)) {
                Node node = session.getNode(path);
                String identifier = node.getIdentifier();
                if (StringUtils.equals(id, identifier) || StringUtils.isEmpty(identifier)) {
                    return path;
                }
                return PathToIDValidator.getSafePath(session, id);
            }
            return PathToIDValidator.getSafePath(session, id);
        }
        catch (RepositoryException e) {
            LOG.warn("Exception mapping '{}' to '{}'", (Object)new String[]{path, id}, (Object)e);
            return null;
        }
    }

    private static String getSafePath(Session session, String identifier) throws ItemNotFoundException, RepositoryException {
        Node nodeById = session.getNodeByIdentifier(identifier);
        if (nodeById != null) {
            return nodeById.getPath();
        }
        LOG.debug("Node not found by id '{}'", (Object)identifier);
        return null;
    }
}

