/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.graphics.chart;

import com.day.cq.graphics.Graph;
import com.day.cq.graphics.chart.BarChart;
import com.day.image.Layer;
import com.day.image.LineStyle;
import java.awt.Color;

public class Grid {
    private final LineStyle lineStyle;
    private final Graph graph;

    public Grid(Graph graph, LineStyle lineStyle) {
        this.lineStyle = lineStyle;
        this.graph = graph;
    }

    public void draw(Layer layer, boolean doDraw) {
        if (!doDraw || this.graph == null) {
            return;
        }
        boolean fancyBars = this.lineStyle.getStyle() == 3 && this.graph.getChart() instanceof BarChart;
        LineStyle style = null;
        if (fancyBars) {
            style = new LineStyle(Color.black, (float)(this.graph.getXAxis().getRangescale() * this.graph.getXAxis().getRangestep()), 1.0f, 1.0f);
        }
        int w = layer.getWidth();
        for (int num = 0; num <= this.graph.getYAxis().numticks; ++num) {
            int y = this.graph.getYAxis().tickpos[num];
            if (y >= layer.getHeight()) continue;
            layer.setLineStyle(this.lineStyle);
            layer.drawLine(0.0f, y, w - 1, y);
            if (!fancyBars) continue;
            layer.setLineStyle(style);
            layer.drawLine(0.0f, y, w - 1, y);
        }
    }

    public LineStyle getLineStyle() {
        return this.lineStyle;
    }
}

