/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;

public abstract class XPath {
    public static final String SEARCH_ALL = "//*";
    public static final String NOT = "not";
    public static final String AND = " and ";
    public static final String OR = " or ";
    public static final String ORDER_BY = " order by ";
    public static final String DESC = " descending";
    public static final String OPTION = " option ";
    public static final String OPENING_BRACKET = "(";
    public static final String CLOSING_BRACKET = ")";
    public static final String PREDICATE_OPENING_BRACKET = "[";
    public static final String PREDICATE_CLOSING_BRACKET = "]";
    public static final String JCR_ROOT = "/jcr:root";
    public static final String JCR_LIKE = "jcr:like";
    public static final String JCR_CONTAINS = "jcr:contains";
    public static final String JCR_LIKE_WILDCARD = "%";
    public static final char JCR_LIKE_ANY_WILDCARD = '%';
    public static final char JCR_LIKE_SINGLE_WILDCARD = '_';
    public static final String REP_EXCERPT = "/rep:excerpt(.)";
    public static final String FN_LOWER_CASE = "fn:lower-case";
    public static final String XPATH_PREFIX = "xpath::";
    public static final String XPATH_FUNCTION_PREFIX = "xpath::fn:";
    public static final String XPATH_FUNCTION_NAME = "xpath::fn:name()";

    public static String getPropertyPath(String property) {
        Object name;
        if (property.charAt(0) == '@') {
            property = property.substring(1);
        }
        name = ((String)(name = Text.getName(property))).charAt(0) != '@' ? "@" + ISO9075.encode((String)name) : "@" + ISO9075.encode(((String)name).substring(1));
        String parent = Text.getRelativeParent(property, 1);
        if (parent.length() > 0) {
            return ISO9075.encodePath(parent) + "/" + (String)name;
        }
        return name;
    }

    public static String getStringLiteral(String value) {
        return "'" + value.replaceAll("'", "''") + "'";
    }

    private static int count(String s, char c) {
        if (s == null || s.length() == 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static String getFulltextStringLiteral(String value) {
        int doubleQuotes = XPath.count((String)value, '\"');
        if (doubleQuotes % 2 == 1) {
            int last = ((String)value).lastIndexOf(34);
            value = ((String)value).substring(0, last) + "\\" + ((String)value).substring(last);
        }
        value = Text.escapeIllegalXpathSearchChars((String)value);
        return "'" + ((String)value).replaceAll("'", "''") + "'";
    }

    public static String getEqualsExpression(String property, String value) {
        return XPath.getPropertyPath(property) + " = " + XPath.getStringLiteral(value);
    }

    public static String getCaseInsensitiveEqualsExpression(String property, String value) {
        return "fn:lower-case(" + XPath.getPropertyPath(property) + ")=" + XPath.getStringLiteral(value).toLowerCase();
    }

    public static String getCaseInsensitiveUnqualsExpression(String property, String value) {
        return "fn:lower-case(" + XPath.getPropertyPath(property) + ")!=" + XPath.getStringLiteral(value).toLowerCase();
    }

    public static String getUnequalsExpression(String property, String value) {
        return XPath.getPropertyPath(property) + " != " + XPath.getStringLiteral(value);
    }

    public static String getJcrLikeExpression(String property, String value) {
        return "jcr:like(" + XPath.getPropertyPath(property) + ", " + XPath.getStringLiteral(value) + CLOSING_BRACKET;
    }

    public static String getNotExpression(String property) {
        return "not(" + XPath.getPropertyPath(property) + CLOSING_BRACKET;
    }

    public static String getXPathOrderBy(String property, boolean ascending) {
        return XPath.getXPathOrderBy(property, ascending, false);
    }

    public static String getXPathOrderBy(String property, boolean ascending, boolean ignoreCase) {
        String orderBy = property.startsWith(XPATH_PREFIX) ? StringUtils.removeStart(property, XPATH_PREFIX) : XPath.getPropertyPath(property);
        if (ignoreCase) {
            return "fn:lower-case(" + orderBy + CLOSING_BRACKET + (ascending ? "" : DESC);
        }
        return orderBy + (ascending ? "" : DESC);
    }
}

