/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.util;

import com.day.cq.wcm.designimporter.DesignImporterContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;

public class ImageMapExtractor {
    private static final String ATTRIBUTE_NAME = "attribute";
    private static final String AREA_ATTRIBUTE_REGEX = "(?is)<area.*? attribute\\s*=\\s*\"(.*?)\".*?>";
    private static final String TITLE_ATTR = "title";
    private static final String TARGET_ATTR = "target";
    private static final String ALT_ATTR = "alt";
    private static final String HREF_ATTR = "href";
    private static final String COORDS_ATTR = "coords";
    private static final String SHAPE_ATTR = "shape";
    private static final String AREA_PATTERN_REGEX = "<area.*?>";
    private static final String MAP_PATTERN_REGEX = "(?is)<map.*? name\\s*=\\s*\"(.*?)\".*?</map>";

    public static Map<String, String> getImagemapsMap(String input, DesignImporterContext designImporterContext) {
        HashMap<String, String> imagemapsMap = new HashMap<String, String>();
        Pattern mapPattern = Pattern.compile(MAP_PATTERN_REGEX);
        Matcher mapMatcher = mapPattern.matcher(input);
        while (mapMatcher.find()) {
            String mapElement = mapMatcher.group();
            String mapName = mapMatcher.group(1);
            Pattern areaPattern = Pattern.compile(AREA_PATTERN_REGEX);
            Matcher areaMatcher = areaPattern.matcher(mapElement);
            StringBuilder areasBuilder = new StringBuilder();
            while (areaMatcher.find()) {
                String areaElement = areaMatcher.group();
                String translatedArea = ImageMapExtractor.translateAreaElement(areaElement, designImporterContext);
                areasBuilder.append(translatedArea);
            }
            imagemapsMap.put(mapName, areasBuilder.toString());
        }
        return imagemapsMap;
    }

    public static String getFinalHtml(String input, List<String> maps) {
        StringBuffer strBuf = new StringBuffer();
        Pattern mapPattern = Pattern.compile(MAP_PATTERN_REGEX);
        Matcher mapMatcher = mapPattern.matcher(input);
        int startIndex = 0;
        int endIndex = 0;
        while (mapMatcher.find()) {
            mapMatcher.group();
            String mapName = mapMatcher.group(1);
            if (!maps.contains(mapName)) continue;
            endIndex = mapMatcher.start();
            strBuf.append(input.substring(startIndex, endIndex));
            startIndex = mapMatcher.end();
        }
        strBuf.append(input.substring(startIndex));
        return strBuf.toString();
    }

    private static String translateAreaElement(String areaElement, DesignImporterContext designImporterContext) {
        String shape = ImageMapExtractor.getAttributeValue(SHAPE_ATTR, areaElement);
        String coords = ImageMapExtractor.getAttributeValue(COORDS_ATTR, areaElement);
        String href = ImageMapExtractor.getAttributeValue(HREF_ATTR, areaElement);
        String alt = ImageMapExtractor.getAttributeValue(ALT_ATTR, areaElement);
        String target = ImageMapExtractor.getAttributeValue(TARGET_ATTR, areaElement);
        if (StringUtils.isEmpty(alt)) {
            alt = ImageMapExtractor.getAttributeValue(TITLE_ATTR, areaElement);
        }
        return ImageMapExtractor.getMapText(shape, coords, href, target, alt, designImporterContext);
    }

    private static String getMapText(String shape, String coords, String href, String target, String title, DesignImporterContext designImporterContext) {
        StringBuffer strBuf = new StringBuffer();
        if (!StringUtils.isEmpty(shape)) {
            strBuf.append('[').append(shape);
            if (!StringUtils.isEmpty(coords)) {
                strBuf.append('(').append(coords).append(')');
            }
            if (!StringUtils.isEmpty(href)) {
                if (designImporterContext != null) {
                    strBuf.append('\"').append(ImageMapExtractor.getAbsolutePath(href, designImporterContext)).append('\"');
                } else {
                    strBuf.append('\"').append(href).append('\"');
                }
            }
            strBuf.append('|');
            if (!StringUtils.isEmpty(target)) {
                strBuf.append('\"').append(target).append('\"');
            }
            strBuf.append('|');
            if (!StringUtils.isEmpty(title)) {
                strBuf.append('\"').append(title).append('\"');
            }
            strBuf.append(']');
        }
        return strBuf.toString();
    }

    private static String getAttributeValue(String attribute, String element) {
        Pattern attribPattern = Pattern.compile(AREA_ATTRIBUTE_REGEX.replace(ATTRIBUTE_NAME, attribute));
        Matcher m = attribPattern.matcher(element);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    private static boolean isAbsoluteUrl(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private static String getAbsolutePath(String src, DesignImporterContext designImporterContext) {
        if (ImageMapExtractor.isAbsoluteUrl(src)) {
            return src;
        }
        try {
            if (!designImporterContext.designNode.hasNode(src)) {
                designImporterContext.importWarnings.add("Could not locate the referenced map href '" + src + "' in the design archive");
                return src;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        String designPath = null;
        try {
            designPath = designImporterContext.designNode.getPath();
        }
        catch (RepositoryException e) {
            designImporterContext.importWarnings.add("Could not locate the referenced map href '" + src + "' in the design archive");
            return src;
        }
        return designPath + "/" + src;
    }
}

