/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.commons.Filter;
import com.day.cq.commons.RangeIterator;
import com.day.cq.search.Predicate;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.SimpleSearch;
import com.day.cq.search.result.Hit;
import com.day.cq.search.result.SearchResult;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageFilter;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.WCMException;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.apache.commons.collections4.iterators.EmptyIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class List {
    public static final Logger log = LoggerFactory.getLogger(List.class);
    public static final String DEFAULT_QUERY = "";
    public static final String URL_EXTENSION = ".html";
    public static final String TYPE_PROPERTY_NAME = "displayAs";
    public static final String SOURCE_PROPERTY_NAME = "listFrom";
    public static final String SOURCE_CHILDREN = "children";
    public static final String SOURCE_DESCENDANTS = "descendants";
    public static final String SOURCE_STATIC = "static";
    public static final String SOURCE_SEARCH = "search";
    public static final String SOURCE_QUERYBUILDER = "querybuilder";
    public static final String SOURCE_TAGS = "tags";
    public static final String TYPE_DEFAULT = "default";
    public static final String PARENT_PAGE_PROPERTY_NAME = "parentPage";
    public static final String ANCESTOR_PAGE_PROPERTY_NAME = "ancestorPage";
    public static final String TAGS_SEARCH_ROOT_PROPERTY_NAME = "tagsSearchRoot";
    public static final String TAGS_PROPERTY_NAME = "tags";
    public static final String TAGS_MATCH_PROPERTY_NAME = "tagsMatch";
    public static final String PAGES_PROPERTY_NAME = "pages";
    public static final String QUERY_PROPERTY_NAME = "query";
    public static final String SEARCH_IN_PROPERTY_NAME = "searchIn";
    public static final String SEARCH_PROPERTY = ".";
    public static final String LIMIT_PROPERTY_NAME = "limit";
    public static final String PAGE_MAX_PROPERTY_NAME = "pageMax";
    public static final String ORDER_BY_PROPERTY_NAME = "orderBy";
    public static final String ORDERED_PROPERTY_NAME = "ordered";
    public static final String SAVEDQUERY_PROPERTY_NAME = "savedquery";
    public static final String PAGE_START_PARAM_NAME = "start";
    public static final String PAGE_MAX_PARAM_NAME = "max";
    public static final String ALLOW_DUPLICATES_PROPERTY_NAME = "allowDuplicates";
    private String id;
    private SlingHttpServletRequest request;
    private java.util.List<Resource> resources;
    private java.util.List<PageWrapper> pages;
    private Iterator<Page> pageIterator;
    private Iterator<Node> nodeIterator;
    private boolean inited;
    private boolean ordered;
    private String source;
    private String query;
    private String queryType;
    private String startIn;
    private String type;
    private String orderBy;
    private Comparator<Page> orderComparator;
    private int limit = -1;
    private int pageMaximum = -1;
    private int pageStart = 0;
    private Resource resource;
    private ValueMap properties;
    private PageFilter pageFilter;

    public List(SlingHttpServletRequest request) {
        this(request, null);
    }

    public List(SlingHttpServletRequest request, PageFilter pageFilter) {
        this.request = request;
        this.pageFilter = pageFilter;
        this.resource = request.getResource();
        this.generateId();
    }

    private void initConfig() {
        this.properties = ResourceUtil.getValueMap(this.resource);
        if (this.source == null) {
            this.source = this.properties.get(SOURCE_PROPERTY_NAME, SOURCE_STATIC);
        }
        if (this.query == null) {
            this.query = this.properties.get(QUERY_PROPERTY_NAME, DEFAULT_QUERY);
        }
        if (this.startIn == null) {
            this.startIn = this.properties.get(SEARCH_IN_PROPERTY_NAME, Text.getAbsoluteParent(this.resource.getPath(), 1));
        }
        if (this.type == null) {
            this.type = this.properties.get(TYPE_PROPERTY_NAME, TYPE_DEFAULT);
        }
        if (this.orderBy == null) {
            this.orderBy = (String)((Object)this.properties.get(ORDER_BY_PROPERTY_NAME, String.class));
        }
        if (this.limit < 0) {
            this.limit = this.properties.get(LIMIT_PROPERTY_NAME, 100);
        }
        if (this.pageMaximum < 0) {
            this.pageMaximum = this.properties.get(PAGE_MAX_PROPERTY_NAME, -1);
        }
        this.ordered = this.properties.get(ORDERED_PROPERTY_NAME, this.ordered);
        if (this.getParameter(PAGE_START_PARAM_NAME) != null) {
            try {
                this.pageStart = Integer.parseInt(this.getParameter(PAGE_START_PARAM_NAME));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.getParameter(PAGE_MAX_PARAM_NAME) != null) {
            try {
                this.pageMaximum = Integer.parseInt(this.getParameter(PAGE_MAX_PARAM_NAME));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private boolean init() {
        if (!this.inited) {
            block33: {
                this.initConfig();
                if (this.pageIterator == null) {
                    ResourceResolver resolver = this.request.getResourceResolver();
                    PageManager pageManager = resolver.adaptTo(PageManager.class);
                    boolean allowDuplicates = this.properties.get(ALLOW_DUPLICATES_PROPERTY_NAME, false);
                    try {
                        String parentPath;
                        Session session = resolver.adaptTo(Session.class);
                        if (SOURCE_QUERYBUILDER.equals(this.source)) {
                            QueryBuilder queryBuilder = resolver.adaptTo(QueryBuilder.class);
                            if (session == null || queryBuilder == null) break block33;
                            try {
                                com.day.cq.search.Query query = queryBuilder.loadQuery(this.resource.getPath() + "/" + SAVEDQUERY_PROPERTY_NAME, session);
                                if (query != null) {
                                    SearchResult result = query.getResult();
                                    this.pageIterator = new HitBasedPageIterator(pageManager, result.getHits().iterator(), !allowDuplicates, this.pageFilter);
                                    this.nodeIterator = result.getNodes();
                                }
                                break block33;
                            }
                            catch (Exception e) {
                                log.error("error loading stored querybuilder query from " + this.resource.getPath(), e);
                            }
                            break block33;
                        }
                        if (SOURCE_SEARCH.equals(this.source)) {
                            if (DEFAULT_QUERY.equals(this.query)) {
                                this.pageIterator = EmptyIterator.INSTANCE;
                            }
                            if (this.queryType != null) {
                                Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(this.query, this.queryType);
                                QueryResult result = jcrQuery.execute();
                                this.pageIterator = new NodeBasedPageIterator(pageManager, result.getNodes(), !allowDuplicates, this.pageFilter);
                            } else {
                                SimpleSearch search = this.getSearch(this.resource.getPath());
                                search.setQuery(this.query);
                                search.setSearchIn(this.startIn);
                                search.setSearchProperties(SEARCH_PROPERTY);
                                search.addPredicate(new Predicate("type", "type").set("type", "cq:Page"));
                                search.setHitsPerPage(100000L);
                                SearchResult result = search.getResult();
                                this.pageIterator = new HitBasedPageIterator(pageManager, result.getHits().iterator(), !allowDuplicates, this.pageFilter);
                            }
                        } else if (SOURCE_CHILDREN.equals(this.source) || SOURCE_DESCENDANTS.equals(this.source)) {
                            parentPath = null;
                            boolean deep = false;
                            if (SOURCE_CHILDREN.equals(this.source)) {
                                parentPath = this.properties.get(PARENT_PAGE_PROPERTY_NAME, this.resource.getPath());
                            } else if (SOURCE_DESCENDANTS.equals(this.source)) {
                                deep = true;
                                parentPath = this.properties.get(ANCESTOR_PAGE_PROPERTY_NAME, this.resource.getPath());
                            }
                            Page startPage = pageManager.getContainingPage(parentPath);
                            if (startPage != null) {
                                PageFilter pageFilter = this.pageFilter != null ? this.pageFilter : new PageFilter();
                                this.pageIterator = startPage.listChildren(pageFilter, deep);
                            } else {
                                this.pageIterator = EmptyIterator.INSTANCE;
                            }
                        } else if ("tags".equals(this.source)) {
                            parentPath = this.properties.get(TAGS_SEARCH_ROOT_PROPERTY_NAME, this.resource.getPath());
                            String[] tags = this.properties.get("tags", new String[0]);
                            boolean matchAny = this.properties.get(TAGS_MATCH_PROPERTY_NAME, "any").equals("any");
                            Page startPage = pageManager.getContainingPage(parentPath);
                            if (startPage != null && tags.length > 0) {
                                TagManager tagManager = this.request.getResourceResolver().adaptTo(TagManager.class);
                                RangeIterator<Resource> results = tagManager.find(startPage.getPath(), tags, matchAny);
                                LinkedHashMap<String, Page> pages = new LinkedHashMap<String, Page>();
                                while (results.hasNext()) {
                                    Resource r = (Resource)results.next();
                                    Page page = pageManager.getContainingPage(r);
                                    if (page == null || this.pageFilter != null && !this.pageFilter.includes(page)) continue;
                                    pages.put(page.getPath(), page);
                                }
                                this.pageIterator = pages.values().iterator();
                            } else {
                                this.pageIterator = EmptyIterator.INSTANCE;
                            }
                        } else {
                            String[] statics;
                            ArrayList<Page> staticPages = new ArrayList<Page>();
                            for (String path : statics = this.properties.get(PAGES_PROPERTY_NAME, new String[0])) {
                                Page p = pageManager.getContainingPage(path);
                                if (p == null || this.pageFilter != null && !this.pageFilter.includes(p)) continue;
                                staticPages.add(p);
                            }
                            this.pageIterator = staticPages.iterator();
                        }
                    }
                    catch (Exception e) {
                        log.error("error creating page iterator", e);
                    }
                }
            }
            this.pages = new ArrayList<PageWrapper>();
            this.resources = new ArrayList<Resource>();
            if (this.pageIterator == null) {
                return false;
            }
            while (this.pageIterator.hasNext()) {
                PageWrapperImpl wrappedPage = new PageWrapperImpl(this.pageIterator.next());
                this.pages.add(wrappedPage);
            }
            if (this.orderComparator != null) {
                Collections.sort(this.pages, this.orderComparator);
            } else if (this.orderBy != null) {
                Collections.sort(this.pages, new PageComparator(this.orderBy));
            }
            if (this.pages.size() > this.limit) {
                this.pages = this.pages.subList(0, this.limit);
            }
            for (Page page : this.pages) {
                this.resources.add(page.getContentResource());
            }
            this.inited = true;
        }
        return true;
    }

    private void generateId() {
        String rootMarker;
        String path = this.resource.getPath();
        int root = path.indexOf(rootMarker = "jcr:content/");
        if (root >= 0) {
            path = path.substring(root + rootMarker.length());
        }
        this.id = path.replace('/', '_');
    }

    private SimpleSearch getSearch(String path) {
        try {
            Resource res = this.request.getResourceResolver().getResource(path);
            SimpleSearch search = res.adaptTo(SimpleSearch.class);
            if (search != null) {
                return search;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (path.lastIndexOf("/") > 0) {
            return this.getSearch(Text.getRelativeParent(path, 1));
        }
        return null;
    }

    private String getParameter(String name) {
        return this.request.getParameter(this.id + "_" + name);
    }

    public Iterator<Resource> getResources() {
        return this.init() && this.resources.size() > 0 ? this.resources.iterator() : null;
    }

    public Iterator<Page> getPages() {
        if (this.init() && this.pages.size() > 0) {
            ArrayList<Page> plist = new ArrayList<Page>();
            int c = 0;
            for (int i = 0; i < this.pages.size(); ++i) {
                if (i < this.pageStart) continue;
                plist.add(this.pages.get(i));
                if (this.pageMaximum > 0 && ++c == this.pageMaximum) break;
            }
            return plist.iterator();
        }
        return null;
    }

    public Iterator<Node> getNodes() {
        return this.init() ? this.nodeIterator : null;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isEmpty() {
        return !this.init() || this.resources.isEmpty();
    }

    public int size() {
        return this.init() ? this.resources.size() : 0;
    }

    public boolean isPaginating() {
        return this.pageStart > 0 || this.pageMaximum > 0 && this.size() > this.pageMaximum;
    }

    public int getPageStart() {
        return this.pageStart;
    }

    public int getPageMaximum() {
        return this.pageMaximum;
    }

    public String getNextPageLink() {
        if (this.isPaginating() && this.pageMaximum > 0 && this.pageStart + this.pageMaximum < this.size()) {
            int start = this.pageStart + this.pageMaximum;
            PageLink link = new PageLink(this.request);
            link.setParameter(PAGE_START_PARAM_NAME, start);
            return link.toString();
        }
        return null;
    }

    public String getPreviousPageLink() {
        if (this.isPaginating() && this.pageStart > 0) {
            int start = this.pageMaximum > 0 && this.pageStart > this.pageMaximum ? this.pageStart - this.pageMaximum : 0;
            PageLink link = new PageLink(this.request);
            link.setParameter(PAGE_START_PARAM_NAME, start);
            return link.toString();
        }
        return null;
    }

    public void setSource(String src) {
        this.source = src;
    }

    public void setQuery(String q) {
        this.setQuery(q, null);
    }

    public void setQuery(String q, String type) {
        this.query = q;
        this.queryType = type;
    }

    public void setStartIn(String start) {
        this.startIn = start;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String t) {
        this.type = t;
    }

    public void setOrderComparator(Comparator<Page> obc) {
        this.orderComparator = obc;
    }

    public void setOrderBy(String ob) {
        this.orderBy = ob;
    }

    public void setOrdered(boolean o) {
        this.ordered = o;
    }

    public void setLimit(int l) {
        this.limit = l;
    }

    public void setPageMaximum(int pm) {
        this.pageMaximum = pm;
    }

    public void setPageStart(int psi) {
        this.pageStart = psi;
    }

    public void setPageIterator(Iterator<Page> iter) {
        this.pageIterator = iter;
        this.setSource(SOURCE_STATIC);
    }

    private class PageWrapperImpl
    implements PageWrapper {
        private Page page;
        private Resource resource;

        public PageWrapperImpl(Page page) {
            this.page = page;
        }

        @Override
        public Resource getRootResource() {
            if (this.resource == null) {
                this.resource = this.page.adaptTo(Resource.class);
            }
            return this.resource;
        }

        @Override
        public String getDescription() {
            return this.page.getDescription();
        }

        @Override
        public <AdapterType> AdapterType adaptTo(Class<AdapterType> aClass) {
            return this.page.adaptTo(aClass);
        }

        @Override
        public String getPath() {
            return this.page.getPath();
        }

        @Override
        public PageManager getPageManager() {
            return this.page.getPageManager();
        }

        @Override
        public Resource getContentResource() {
            return this.page.getContentResource();
        }

        @Override
        public Resource getContentResource(String s) {
            return this.page.getContentResource(s);
        }

        @Override
        public Iterator<Page> listChildren() {
            return this.page.listChildren();
        }

        @Override
        public Iterator<Page> listChildren(Filter<Page> filter) {
            return this.page.listChildren(filter);
        }

        @Override
        public Iterator<Page> listChildren(Filter<Page> filter, boolean b) {
            return this.page.listChildren(filter, b);
        }

        @Override
        public boolean hasChild(String s) {
            return this.page.hasChild(s);
        }

        @Override
        public int getDepth() {
            return this.page.getDepth();
        }

        @Override
        public Page getParent() {
            return this.page.getParent();
        }

        @Override
        public Page getParent(int i) {
            return this.page.getParent(i);
        }

        @Override
        public Page getAbsoluteParent(int i) {
            return this.page.getAbsoluteParent(i);
        }

        @Override
        public ValueMap getProperties() {
            return this.page.getProperties();
        }

        @Override
        public ValueMap getProperties(String s) {
            return this.page.getProperties(s);
        }

        @Override
        public String getName() {
            return this.page.getName();
        }

        @Override
        public String getTitle() {
            return this.page.getTitle();
        }

        @Override
        public String getPageTitle() {
            return this.page.getPageTitle();
        }

        @Override
        public String getNavigationTitle() {
            return this.page.getNavigationTitle();
        }

        @Override
        public boolean isHideInNav() {
            return this.page.isHideInNav();
        }

        @Override
        public boolean hasContent() {
            return this.page.hasContent();
        }

        @Override
        public boolean isValid() {
            return this.page.isValid();
        }

        @Override
        public long timeUntilValid() {
            return this.page.timeUntilValid();
        }

        @Override
        public Calendar getOnTime() {
            return this.page.getOnTime();
        }

        @Override
        public Calendar getOffTime() {
            return this.page.getOffTime();
        }

        @Override
        public Calendar getDeleted() {
            return this.page.getDeleted();
        }

        @Override
        public String getDeletedBy() {
            return this.page.getDeletedBy();
        }

        @Override
        public String getLastModifiedBy() {
            return this.page.getLastModifiedBy();
        }

        @Override
        public Calendar getLastModified() {
            return this.page.getLastModified();
        }

        @Override
        public String getVanityUrl() {
            return this.page.getVanityUrl();
        }

        @Override
        public Tag[] getTags() {
            return this.page.getTags();
        }

        @Override
        public void lock() throws WCMException {
            this.page.lock();
        }

        @Override
        public boolean isLocked() {
            return this.page.isLocked();
        }

        @Override
        public String getLockOwner() {
            return this.page.getLockOwner();
        }

        @Override
        public boolean canUnlock() {
            return this.page.canUnlock();
        }

        @Override
        public void unlock() throws WCMException {
            this.page.unlock();
        }

        @Override
        public Template getTemplate() {
            return this.page.getTemplate();
        }

        @Override
        public Locale getLanguage(boolean b) {
            return this.page.getLanguage(b);
        }

        @Override
        public Locale getLanguage() {
            return this.page.getLanguage();
        }
    }

    private static interface PageWrapper
    extends Page {
        public Resource getRootResource();
    }

    private class HitBasedPageIterator
    extends AbstractPageIterator {
        private Iterator<Hit> hits;

        public HitBasedPageIterator(PageManager pm, Iterator<Hit> hits, boolean avoidDuplicates, PageFilter pageFilter) {
            this.pm = pm;
            this.hits = hits;
            if (avoidDuplicates) {
                this.seen = new HashSet();
            }
            this.pageFilter = pageFilter;
            this.nextPage = this.seek();
        }

        @Override
        protected Page seek() {
            while (this.hits != null && this.hits.hasNext()) {
                try {
                    Page page = this.pm.getContainingPage(this.hits.next().getResource());
                    if (page == null || this.seen != null && !this.seen.add(page.getPath()) || this.pageFilter != null && !this.pageFilter.includes(page)) continue;
                    return page;
                }
                catch (Exception e) {
                    log.error("Could not get page behind search result hit", e);
                }
            }
            return null;
        }
    }

    private class NodeBasedPageIterator
    extends AbstractPageIterator {
        private NodeIterator nodes;

        public NodeBasedPageIterator(PageManager pm, NodeIterator nodes, boolean avoidDuplicates, PageFilter pageFilter) {
            this.pm = pm;
            this.nodes = nodes;
            if (avoidDuplicates) {
                this.seen = new HashSet();
            }
            this.pageFilter = pageFilter;
            this.nextPage = this.seek();
        }

        @Override
        protected Page seek() {
            while (this.nodes != null && this.nodes.hasNext()) {
                try {
                    Page page = this.pm.getContainingPage(this.nodes.nextNode().getPath());
                    if (page == null || this.seen != null && !this.seen.add(page.getPath()) || this.pageFilter != null && !this.pageFilter.includes(page)) continue;
                    return page;
                }
                catch (Exception e) {
                    log.error("Could not get page behind result node", e);
                }
            }
            return null;
        }
    }

    private abstract class AbstractPageIterator
    implements Iterator<Page> {
        protected PageManager pm;
        protected Page nextPage;
        protected Set<String> seen;
        protected PageFilter pageFilter;

        private AbstractPageIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.nextPage != null;
        }

        @Override
        public Page next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Page page = this.nextPage;
            this.nextPage = this.seek();
            return page;
        }

        protected abstract Page seek();

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class PageLink {
        private String path;
        private HashMap<String, Object> params;

        public PageLink(SlingHttpServletRequest request) {
            this.path = request.getPathInfo();
            PageManager pm = request.getResourceResolver().adaptTo(PageManager.class);
            Page page = pm.getContainingPage(this.path);
            if (page != null) {
                this.path = page.getPath() + List.URL_EXTENSION;
            }
            this.initParams(request.getQueryString());
        }

        public void addParameter(String name, Object value) {
            name = this.prefixName(name);
            this.params.put(name, value);
        }

        public void setParameter(String name, Object value) {
            if (this.params.containsKey(name = this.prefixName(name))) {
                this.params.remove(name);
            }
            this.addParameter(name, value);
        }

        public String toString() {
            String url = this.path;
            for (String param : this.params.keySet()) {
                url = this.appendParam(url, param, this.params.get(param));
            }
            return url;
        }

        private String prefixName(String name) {
            if (!name.startsWith(List.this.id + "_")) {
                name = List.this.id + "_" + name;
            }
            return name;
        }

        private void initParams(String query) {
            String[] pairs;
            this.params = new HashMap();
            for (String pair : pairs = Text.explode(query, 38)) {
                String[] param = Text.explode(pair, 61, true);
                this.params.put(param[0], param[1]);
            }
        }

        private String appendParam(String url, String name, Object value) {
            char delim = url.indexOf(63) > 0 ? (char)'&' : '?';
            return new StringBuffer(url).append(delim).append(name).append('=').append(value).toString();
        }
    }

    public class PageComparator<P extends Page>
    implements Comparator<P> {
        private String property;
        private boolean orderByJcrCreated;
        private static final String JCR_CREATED = "jcr:created";

        public PageComparator(String prop) {
            this.property = prop;
            this.orderByJcrCreated = this.isOrderByJcrCreated(prop);
        }

        @Override
        public int compare(P p1, P p2) {
            int comp = this.getKey(p1).compareTo(this.getKey(p2));
            return comp != 0 && this.isDate((Page)p1, this.property) && this.isDate((Page)p2, this.property) ? -comp : comp;
        }

        private String getKey(P p) {
            if (this.orderByJcrCreated && PageWrapper.class.isAssignableFrom(p.getClass())) {
                ValueMap pageNodeMap = ((PageWrapper)p).getRootResource().getValueMap();
                return pageNodeMap.get(this.property, List.DEFAULT_QUERY);
            }
            return p.getProperties().get(this.property, List.DEFAULT_QUERY);
        }

        private boolean isDate(Page page, String prop) {
            if (page == null || page.getContentResource() == null) {
                return false;
            }
            Node pageContentNode = page.getContentResource().adaptTo(Node.class);
            Calendar date = null;
            try {
                Property property = pageContentNode.getProperty(prop);
                if (property == null) {
                    return false;
                }
                date = property.getDate();
            }
            catch (ValueFormatException vfe) {
                return false;
            }
            catch (RepositoryException re) {
                return false;
            }
            return date != null;
        }

        private boolean isOrderByJcrCreated(String prop) {
            return prop.matches(JCR_CREATED);
        }
    }
}

