/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.msm.commons;

import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.msm.api.LiveRelationship;
import com.day.cq.wcm.msm.commons.BaseAction;
import com.day.cq.wcm.msm.commons.BaseActionFactory;
import com.day.cq.wcm.msm.commons.ItemFilterImpl;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.FunctorException;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FilteredAction
extends BaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilteredAction.class);
    private final ItemFilterImpl componentItemFilter;
    private final ItemFilterImpl pagePropertyFilter;

    protected FilteredAction(ValueMap configuration, ItemFilterImpl pageItemFilter, ItemFilterImpl componentItemFilter, BaseActionFactory<? extends FilteredAction> factory) {
        super(configuration, factory);
        this.pagePropertyFilter = pageItemFilter;
        this.componentItemFilter = componentItemFilter;
    }

    @Override
    protected boolean handles(Resource source, Resource target, LiveRelationship relation, boolean resetRollout) throws RepositoryException, WCMException {
        return this.filter(source, target) && this.doHandle(source, target, relation, resetRollout);
    }

    protected abstract boolean doHandle(Resource var1, Resource var2, LiveRelationship var3, boolean var4) throws RepositoryException, WCMException;

    protected ItemFilterImpl getFilter(Node node) throws RepositoryException {
        if (FilteredAction.isPage(node)) {
            return this.pagePropertyFilter;
        }
        return this.componentItemFilter;
    }

    protected Iterator<Property> getFilteredProperties(Node node) throws RepositoryException {
        return FilteredAction.filteredIterator(node.getProperties(), new FilterPredicate(this.getFilter(node)));
    }

    protected Iterator<Node> getFilteredNodes(Node node) throws RepositoryException {
        return FilteredAction.filteredIterator(node.getNodes(), new FilterPredicate(this.getFilter(node)));
    }

    private boolean filter(Resource source, Resource target) throws RepositoryException {
        Node sourceNode = source != null ? source.adaptTo(Node.class) : null;
        Node targetNode = target != null ? target.adaptTo(Node.class) : null;
        Node checkNode = sourceNode != null ? sourceNode : targetNode;
        return checkNode == null || !this.getFilter(checkNode).excludes(checkNode);
    }

    private static <E> Iterator<E> filteredIterator(Iterator<E> iterator, java.util.function.Predicate<E> predicate) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).filter(predicate).iterator();
    }

    private static final class FilterPredicate<E>
    implements java.util.function.Predicate<E> {
        private final ItemFilterImpl filter;

        private FilterPredicate(ItemFilterImpl filter) {
            this.filter = filter;
        }

        @Override
        public boolean test(E object) {
            try {
                if (object instanceof Property) {
                    return !this.filter.excludes((Property)object);
                }
                return !this.filter.excludes((Node)object);
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static final class ItemFilterPredicate
    implements Predicate {
        private final ItemFilterImpl filter;

        protected ItemFilterPredicate(ItemFilterImpl filter) {
            this.filter = filter;
            LOGGER.error("Class {} should not be used.", (Object)this.getClass().getName());
        }

        @Override
        public boolean evaluate(Object object) {
            try {
                if (object instanceof Property) {
                    return !this.filter.excludes((Property)object);
                }
                return !this.filter.excludes((Node)object);
            }
            catch (RepositoryException e) {
                throw new FunctorException(e);
            }
        }
    }
}

