/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.workflow.process;

import com.day.cq.replication.ReplicationActionType;
import com.day.cq.replication.ReplicationException;
import com.day.cq.replication.Replicator;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.Collections;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service(value={WorkflowProcess.class})
@Property(name="process.label", value={"Replicate After Page Move"})
public class AfterMovePageProcess
implements WorkflowProcess {
    @Reference
    protected ResourceResolverFactory resourceResolverFactory;
    @Reference
    protected Replicator replicator;
    private static final Logger log = LoggerFactory.getLogger(AfterMovePageProcess.class);

    @Override
    public void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap args) throws WorkflowException {
        try {
            MetaDataMap metaDataMap = workItem.getWorkflowData().getMetaDataMap();
            String srcPath = (String)((Object)metaDataMap.get("srcPath", String.class));
            ReplicationActionType replicationType = ReplicationActionType.valueOf((String)((Object)metaDataMap.get("replicationType", String.class)));
            String[] publishReferences = (String[])metaDataMap.get("publishReferences", String[].class);
            Session session = workflowSession.getSession();
            ResourceResolver resourceResolver = this.resourceResolverFactory.getResourceResolver(Collections.singletonMap("user.jcr.session", session));
            log.debug("Replicate page in workflow " + srcPath);
            this.replicator.replicate(session, replicationType, srcPath);
            if (publishReferences != null) {
                for (String ref : publishReferences) {
                    log.debug("Replicate reference of page (" + srcPath + ") in workflow " + ref);
                    this.replicator.replicate(session, ReplicationActionType.ACTIVATE, ref);
                }
            }
        }
        catch (ReplicationException e) {
            throw new WorkflowException(e);
        }
        catch (LoginException e) {
            throw new WorkflowException(e);
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindReplicator(Replicator replicator) {
        this.replicator = replicator;
    }

    protected void unbindReplicator(Replicator replicator) {
        if (this.replicator == replicator) {
            this.replicator = null;
        }
    }
}

