/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.compatibility;

import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.ScriptContextProvider;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.impl.CQWorkflowSessionWrapper;
import com.day.cq.workflow.impl.exec.CQWorkItemWrapper;
import com.day.cq.workflow.impl.exec.CQWorkflowDataWrapper;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false, label="%cq.workflow.compat.scriptcontext.name", description="%cq.workflow.compat.scriptcontext.description")
@Service(value={ScriptContextProvider.class})
public class ScriptContextProviderImpl
implements ScriptContextProvider {
    private static final String GRANITE_WORKITEM_SCRIPT_ENTRY = "graniteWorkItem";
    private static final String GRANITE_WORKFLOW_SESSION_SCRIPT_PROPERTY = "graniteWorkflowSession";
    private static final String GRANITE_WORKFLOW_DATA = "graniteWorkflowData";
    private static final String WORKITEM_SCRIPT_ENTRY = "workItem";
    private static final String WORKFLOW_SESSION_SCRIPT_PROPERTY = "workflowSession";
    private static final String WORKFLOW_DATA = "workflowData";
    @Reference
    private WorkflowService cqWorkflowService;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public void addContext(Map map) {
        this.addCQWrappedObject(map, GRANITE_WORKITEM_SCRIPT_ENTRY, WORKITEM_SCRIPT_ENTRY, WorkItem.class, CQWorkItemWrapper.class);
        this.addCQWrappedObject(map, GRANITE_WORKFLOW_DATA, WORKFLOW_DATA, WorkflowData.class, CQWorkflowDataWrapper.class);
        this.addCQWrappedObjectWithWorkflowService(map, GRANITE_WORKFLOW_SESSION_SCRIPT_PROPERTY, WORKFLOW_SESSION_SCRIPT_PROPERTY, WorkflowSession.class, CQWorkflowSessionWrapper.class);
    }

    private void addCQWrappedObject(Map map, String graniteName, String cqName, Class graniteClass, Class cqClass) {
        try {
            if (map.get(graniteName) != null && graniteClass.isInstance(map.get(graniteName))) {
                map.put(cqName, cqClass.getConstructor(graniteClass).newInstance(map.get(graniteName)));
            }
        }
        catch (Exception e) {
            this.log.error("error setting up CQ Script Context", e);
        }
    }

    private void addCQWrappedObjectWithWorkflowService(Map map, String graniteName, String cqName, Class graniteClass, Class cqClass) {
        try {
            if (map.get(graniteName) != null && graniteClass.isInstance(map.get(graniteName))) {
                map.put(cqName, cqClass.getConstructor(WorkflowService.class, graniteClass).newInstance(this.cqWorkflowService, map.get(graniteName)));
            }
        }
        catch (Exception e) {
            this.log.error("error setting up CQ Script Context", e);
        }
    }

    protected void bindCqWorkflowService(WorkflowService workflowService) {
        this.cqWorkflowService = workflowService;
    }

    protected void unbindCqWorkflowService(WorkflowService workflowService) {
        if (this.cqWorkflowService == workflowService) {
            this.cqWorkflowService = null;
        }
    }
}

