/*
 * Decompiled with CFR 0.152.
 */
package com.day.util.diff;

import com.day.util.diff.DiffWriter;
import com.day.util.diff.Document;
import com.day.util.diff.Range;
import java.io.IOException;

public class Hunk3 {
    public static final String[] MARKER_L = new String[]{"<<<<<<< ", ".mine"};
    public static final String[] MARKER_R = new String[]{">>>>>>> ", ".theirs"};
    public static final String[] MARKER_B = new String[]{"||||||| ", ".base"};
    public static final String[] MARKER_M = new String[]{"=======", ""};
    private final Range base;
    private final Range left;
    private final Range right;
    private Hunk3 next;

    public Hunk3(Range base, Range left, Range right, Hunk3 prev) {
        this.base = base;
        this.left = left;
        this.right = right;
        if (prev != null) {
            prev.next = this;
        }
    }

    public Hunk3 next() {
        return this.next;
    }

    public Range getBaseRange() {
        return this.base;
    }

    public Range getLeftRange() {
        return this.left;
    }

    public Range getRightRange() {
        return this.right;
    }

    public void write(DiffWriter out, boolean showBase) throws IOException {
        int i;
        int len;
        boolean conflict;
        boolean bl = conflict = this.left != null && this.right != null;
        if (conflict) {
            out.write(Hunk3.getMarker(MARKER_L, this.left.doc));
            out.writeNewLine();
        } else {
            boolean bl2 = showBase = this.left == null && this.right == null;
        }
        if (this.left != null) {
            len = Math.min(this.left.high, this.left.doc.getElements().length);
            for (i = this.left.low; i < len; ++i) {
                out.write(this.left.doc.getElements()[i].getString());
            }
        }
        if (showBase) {
            if (conflict) {
                out.write(Hunk3.getMarker(MARKER_B, this.base.doc));
                out.writeNewLine();
            }
            len = Math.min(this.base.high, this.base.doc.getElements().length);
            for (i = this.base.low; i < len; ++i) {
                out.write(this.base.doc.getElements()[i].getString());
            }
        }
        if (conflict) {
            out.write(Hunk3.getMarker(MARKER_M, null));
            out.writeNewLine();
        }
        if (this.right != null) {
            len = Math.min(this.right.high, this.right.doc.getElements().length);
            for (i = this.right.low; i < len; ++i) {
                out.write(this.right.doc.getElements()[i].getString());
            }
        }
        if (conflict) {
            out.write(Hunk3.getMarker(MARKER_R, this.right.doc));
            out.writeNewLine();
        }
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("@@ =").append(this.base).append(" -").append(this.left).append(" +").append(this.right).append(" @@\n");
        if (this.left != null) {
            for (i = 0; i < this.left.len(); ++i) {
                this.addLineNumbers(buf, i);
                buf.append("< ");
                buf.append(this.left.doc.getElements()[i + this.left.low]);
            }
        }
        if (this.base != null) {
            for (i = 0; i < this.base.len(); ++i) {
                this.addLineNumbers(buf, i);
                buf.append("= ");
                buf.append(this.base.doc.getElements()[i + this.base.low]);
            }
        }
        if (this.right != null) {
            for (i = 0; i < this.right.len(); ++i) {
                this.addLineNumbers(buf, i);
                buf.append("> ");
                buf.append(this.right.doc.getElements()[i + this.right.low]);
            }
        }
        return buf.toString();
    }

    private void addLineNumbers(StringBuffer buf, int i) {
        buf.append("(").append(i + this.base.low);
        if (this.left != null) {
            buf.append(",").append(i + this.left.low);
        }
        if (this.right != null) {
            buf.append(",").append(i + this.right.low);
        }
        buf.append(") ");
    }

    public static String getMarker(String[] fmt, Document doc) {
        StringBuffer buf = new StringBuffer(fmt[0]);
        if (doc != null && doc.getSource() != null && doc.getSource().getLabel() != null) {
            buf.append(doc.getSource().getLabel());
        } else {
            buf.append(fmt[1]);
        }
        return buf.toString();
    }
}

