/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common.bytesource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.imaging.common.bytesource.ByteSource;

public class ByteSourceArray
extends ByteSource {
    private final byte[] bytes;

    public ByteSourceArray(String filename, byte[] bytes) {
        super(filename);
        this.bytes = bytes;
    }

    public ByteSourceArray(byte[] bytes) {
        super(null);
        this.bytes = bytes;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public byte[] getBlock(long startLong, int length) throws IOException {
        int start = (int)startLong;
        if (start < 0 || length < 0 || start + length < 0 || start + length > this.bytes.length) {
            throw new IOException("Could not read block (block start: " + start + ", block length: " + length + ", data length: " + this.bytes.length + ").");
        }
        byte[] result = new byte[length];
        System.arraycopy(this.bytes, start, result, 0, length);
        return result;
    }

    public long getLength() {
        return this.bytes.length;
    }

    public byte[] getAll() throws IOException {
        return this.bytes;
    }

    public String getDescription() {
        return this.bytes.length + " byte array";
    }
}

