/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak;

import java.util.Map;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.SimpleCommitContext;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;

public final class OakInitializer {
    public static final String SESSION_ID = "OakInitializer";

    private OakInitializer() {
    }

    public static void initialize(@NotNull NodeStore store, @NotNull RepositoryInitializer initializer, @NotNull CommitHook hook) {
        try {
            NodeBuilder builder = store.getRoot().builder();
            initializer.initialize(builder);
            store.merge(builder, hook, OakInitializer.createCommitInfo());
        }
        catch (CommitFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void initialize(@NotNull Iterable<WorkspaceInitializer> initializer, @NotNull NodeStore store, @NotNull String workspaceName, @NotNull CommitHook hook) {
        NodeBuilder builder = store.getRoot().builder();
        for (WorkspaceInitializer wspInit : initializer) {
            wspInit.initialize(builder, workspaceName);
        }
        try {
            store.merge(builder, hook, OakInitializer.createCommitInfo());
        }
        catch (CommitFailedException e) {
            throw new RuntimeException(e);
        }
    }

    private static CommitInfo createCommitInfo() {
        Map<String, Object> infoMap = Map.of("oak.commitAttributes", new SimpleCommitContext());
        return new CommitInfo(SESSION_ID, null, infoMap);
    }
}

