/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite.checks;

import java.util.Objects;
import java.util.Set;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.checks.ErrorHolder;
import org.apache.jackrabbit.oak.composite.checks.MountedNodeStoreChecker;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.factories.RootFactory;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ComponentPropertyType;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={MountedNodeStoreChecker.class})
public class NodeTypeMountedNodeStoreChecker
implements MountedNodeStoreChecker<Context> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String INVALID_NODE_TYPE = "invalidNodeType";
    private static final String ERROR_LABEL = "errorLabel";
    private static final String EXCLUDED_NODE_TYPES = "excludedNodeTypes";
    private String invalidNodeType;
    private String errorLabel;
    private Set<String> excludedNodeTypes;

    public NodeTypeMountedNodeStoreChecker() {
    }

    public NodeTypeMountedNodeStoreChecker(String invalidNodeType, String errorLabel, String ... excludedNodeTypes) {
        this.invalidNodeType = invalidNodeType;
        this.errorLabel = errorLabel;
        this.excludedNodeTypes = ImmutableSet.copyOf((Object[])excludedNodeTypes);
    }

    protected void activate(ComponentContext ctx) {
        this.invalidNodeType = Objects.requireNonNull(PropertiesUtil.toString(ctx.getProperties().get(INVALID_NODE_TYPE), null), INVALID_NODE_TYPE);
        this.errorLabel = Objects.requireNonNull(PropertiesUtil.toString(ctx.getProperties().get(ERROR_LABEL), null), ERROR_LABEL);
        this.excludedNodeTypes = ImmutableSet.copyOf((Object[])PropertiesUtil.toStringArray(ctx.getProperties().get(EXCLUDED_NODE_TYPES), new String[0]));
    }

    @Override
    public Context createContext(NodeStore globalStore, MountInfoProvider mip) {
        Root globalRoot = RootFactory.createReadOnlyRoot(globalStore.getRoot());
        ReadOnlyNodeTypeManager typeManager = ReadOnlyNodeTypeManager.getInstance(globalRoot, NamePathMapper.DEFAULT);
        return new Context(typeManager);
    }

    @Override
    public boolean check(MountedNodeStore mountedStore, Tree tree, ErrorHolder errorHolder, Context context) {
        if (context.getTypeManager().isNodeType(tree, this.invalidNodeType) && !this.isExcluded(mountedStore, tree, context)) {
            errorHolder.report(mountedStore, tree.getPath(), this.errorLabel, this);
        }
        return true;
    }

    private boolean isExcluded(MountedNodeStore mountedStore, Tree tree, Context context) {
        for (String excludedNodeType : this.excludedNodeTypes) {
            if (!context.getTypeManager().isNodeType(tree, excludedNodeType)) continue;
            this.log.warn("Not failing check for tree at path {}, mount {} due to matching excluded node type {}", tree.getPath(), mountedStore.getMount().getName(), excludedNodeType);
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + ": [ invalidNodeType: " + this.invalidNodeType + ", excludedNodeTypes: " + this.excludedNodeTypes + " ]";
    }

    protected static class Context {
        private final ReadOnlyNodeTypeManager typeManager;

        Context(ReadOnlyNodeTypeManager typeManager) {
            this.typeManager = typeManager;
        }

        public ReadOnlyNodeTypeManager getTypeManager() {
            return this.typeManager;
        }
    }

    @ComponentPropertyType
    static @interface Config {
        @AttributeDefinition(name="The name of a node type that is invalid and will be rejected when found")
        public String invalidNodeType();

        @AttributeDefinition(name="The error label to use when rejecting an invalid node type")
        public String errorLabel();

        @AttributeDefinition(name="Node types that will cause the check to succeeed, even in the invalid node type is also found.", cardinality=0x7FFFFFFF)
        public String[] excludedNodeTypes() default {};
    }
}

