/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.AbstractPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.BooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DecimalPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.DoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.GenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.LongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiBinaryPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiBooleanPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiDecimalPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiDoublePropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiGenericPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiLongPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.MultiStringPropertyState;
import org.apache.jackrabbit.oak.plugins.memory.StringPropertyState;
import org.apache.jackrabbit.oak.plugins.value.Conversions;
import org.apache.jackrabbit.oak.plugins.value.OakValue;
import org.apache.jackrabbit.util.ISO8601;
import org.jetbrains.annotations.NotNull;

public final class PropertyStates {
    private PropertyStates() {
    }

    @NotNull
    public static PropertyState createProperty(String name, Value value) throws RepositoryException {
        int type = value.getType();
        switch (type) {
            case 1: {
                return StringPropertyState.stringProperty(name, PropertyStates.getString(value, type));
            }
            case 2: {
                return BinaryPropertyState.binaryProperty(name, value);
            }
            case 3: {
                return LongPropertyState.createLongProperty(name, value.getLong());
            }
            case 4: {
                return DoublePropertyState.doubleProperty(name, value.getDouble());
            }
            case 6: {
                return BooleanPropertyState.booleanProperty(name, value.getBoolean());
            }
            case 12: {
                return DecimalPropertyState.decimalProperty(name, value.getDecimal());
            }
        }
        return new GenericPropertyState(name, PropertyStates.getString(value, type), Type.fromTag(type, false));
    }

    @NotNull
    public static PropertyState createProperty(String name, Iterable<Value> values) throws RepositoryException {
        int type = 1;
        Value first = (Value)Iterables.getFirst(values, null);
        if (first != null) {
            type = first.getType();
        }
        return PropertyStates.createProperty(name, values, type);
    }

    public static PropertyState createProperty(String name, Iterable<Value> values, int type) throws RepositoryException {
        switch (type) {
            case 1: {
                ArrayList<String> strings = new ArrayList<String>();
                for (Value value : values) {
                    strings.add(PropertyStates.getString(value, type));
                }
                return MultiStringPropertyState.stringProperty(name, strings);
            }
            case 2: {
                ArrayList<Blob> blobs = new ArrayList<Blob>();
                for (Value value : values) {
                    blobs.add(AbstractPropertyState.getBlob(value));
                }
                return MultiBinaryPropertyState.binaryPropertyFromBlob(name, blobs);
            }
            case 3: {
                ArrayList<Long> longs = new ArrayList<Long>();
                for (Value value : values) {
                    longs.add(value.getLong());
                }
                return MultiLongPropertyState.createLongProperty(name, longs);
            }
            case 4: {
                ArrayList<Double> doubles = new ArrayList<Double>();
                for (Value value : values) {
                    doubles.add(value.getDouble());
                }
                return MultiDoublePropertyState.doubleProperty(name, doubles);
            }
            case 6: {
                ArrayList<Boolean> booleans = new ArrayList<Boolean>();
                for (Value value : values) {
                    booleans.add(value.getBoolean());
                }
                return MultiBooleanPropertyState.booleanProperty(name, booleans);
            }
            case 12: {
                ArrayList<BigDecimal> decimals = new ArrayList<BigDecimal>();
                for (Value value : values) {
                    decimals.add(value.getDecimal());
                }
                return MultiDecimalPropertyState.decimalProperty(name, decimals);
            }
        }
        ArrayList<String> vals = new ArrayList<String>();
        for (Value value : values) {
            vals.add(PropertyStates.getString(value, type));
        }
        return new MultiGenericPropertyState(name, vals, Type.fromTag(type, true));
    }

    private static String getString(Value value, int type) throws RepositoryException {
        if (value instanceof OakValue) {
            return ((OakValue)((Object)value)).getOakString();
        }
        if (type == 7 || type == 8) {
            throw new IllegalArgumentException("Cannot create name of path property state from Value of class '" + value.getClass() + "'");
        }
        return value.getString();
    }

    @NotNull
    public static PropertyState createProperty(String name, String value, int type) {
        switch (type) {
            case 1: {
                return StringPropertyState.stringProperty(name, value);
            }
            case 2: {
                return BinaryPropertyState.binaryProperty(name, Conversions.convert(value).toBinary());
            }
            case 3: {
                return LongPropertyState.createLongProperty(name, Conversions.convert(value).toLong());
            }
            case 4: {
                return DoublePropertyState.doubleProperty(name, Conversions.convert(value).toDouble());
            }
            case 6: {
                return BooleanPropertyState.booleanProperty(name, Conversions.convert(value).toBoolean());
            }
            case 12: {
                return DecimalPropertyState.decimalProperty(name, Conversions.convert(value).toDecimal());
            }
        }
        return new GenericPropertyState(name, value, Type.fromTag(type, false));
    }

    @NotNull
    public static PropertyState createProperty(String name, Object value, Type<?> type) {
        switch (type.tag()) {
            case 1: {
                return type.isArray() ? MultiStringPropertyState.stringProperty(name, (Iterable)value) : StringPropertyState.stringProperty(name, (String)value);
            }
            case 2: {
                return type.isArray() ? MultiBinaryPropertyState.binaryPropertyFromBlob(name, (Iterable)value) : BinaryPropertyState.binaryProperty(name, (Blob)value);
            }
            case 3: {
                return type.isArray() ? MultiLongPropertyState.createLongProperty(name, (Iterable)value) : LongPropertyState.createLongProperty(name, (Long)value);
            }
            case 4: {
                return type.isArray() ? MultiDoublePropertyState.doubleProperty(name, (Iterable)value) : DoublePropertyState.doubleProperty(name, (Double)value);
            }
            case 5: {
                return type.isArray() ? MultiGenericPropertyState.dateProperty(name, (Iterable)value) : GenericPropertyState.dateProperty(name, (String)value);
            }
            case 6: {
                return type.isArray() ? MultiBooleanPropertyState.booleanProperty(name, (Iterable)value) : BooleanPropertyState.booleanProperty(name, (Boolean)value);
            }
            case 7: {
                return type.isArray() ? MultiGenericPropertyState.nameProperty(name, (Iterable)value) : GenericPropertyState.nameProperty(name, (String)value);
            }
            case 8: {
                return type.isArray() ? MultiGenericPropertyState.pathProperty(name, (Iterable)value) : GenericPropertyState.pathProperty(name, (String)value);
            }
            case 9: {
                return type.isArray() ? MultiGenericPropertyState.referenceProperty(name, (Iterable)value) : GenericPropertyState.referenceProperty(name, (String)value);
            }
            case 10: {
                return type.isArray() ? MultiGenericPropertyState.weakreferenceProperty(name, (Iterable)value) : GenericPropertyState.weakreferenceProperty(name, (String)value);
            }
            case 11: {
                return type.isArray() ? MultiGenericPropertyState.uriProperty(name, (Iterable)value) : GenericPropertyState.uriProperty(name, (String)value);
            }
            case 12: {
                return type.isArray() ? MultiDecimalPropertyState.decimalProperty(name, (Iterable)value) : DecimalPropertyState.decimalProperty(name, (BigDecimal)value);
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    @NotNull
    public static <T> PropertyState createProperty(String name, T value) {
        if (value instanceof String) {
            return StringPropertyState.stringProperty(name, (String)value);
        }
        if (value instanceof Blob) {
            return BinaryPropertyState.binaryProperty(name, (Blob)value);
        }
        if (value instanceof byte[]) {
            return BinaryPropertyState.binaryProperty(name, (byte[])value);
        }
        if (value instanceof Long) {
            return LongPropertyState.createLongProperty(name, (Long)value);
        }
        if (value instanceof Integer) {
            return LongPropertyState.createLongProperty(name, ((Integer)value).intValue());
        }
        if (value instanceof Double) {
            return DoublePropertyState.doubleProperty(name, (Double)value);
        }
        if (value instanceof Calendar) {
            return GenericPropertyState.dateProperty(name, ISO8601.format((Calendar)value));
        }
        if (value instanceof Boolean) {
            return BooleanPropertyState.booleanProperty(name, (Boolean)value);
        }
        if (value instanceof BigDecimal) {
            return DecimalPropertyState.decimalProperty(name, (BigDecimal)value);
        }
        throw new IllegalArgumentException("Can't infer type of value of class '" + value.getClass() + "'");
    }

    public static PropertyState convert(PropertyState state, Type<?> type) {
        if (type == state.getType() || type == Type.UNDEFINED && !state.isArray() || type == Type.UNDEFINEDS && state.isArray()) {
            return state;
        }
        return PropertyStates.createProperty(state.getName(), state.getValue(type), type);
    }
}

