/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryChildNodeEntry;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.ReadOnlyBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDecoratedNodeState
extends AbstractNodeState {
    protected final NodeState delegate;
    private final boolean useNativeEquals;

    protected AbstractDecoratedNodeState(@NotNull NodeState delegate, boolean useNativeEquals) {
        this.delegate = delegate;
        this.useNativeEquals = useNativeEquals;
    }

    public NodeState getDelegate() {
        return this.delegate;
    }

    protected boolean hideChild(@NotNull String name, @NotNull NodeState delegateChild) {
        return false;
    }

    @NotNull
    protected abstract NodeState decorateChild(@NotNull String var1, @NotNull NodeState var2);

    @NotNull
    private NodeState decorate(@NotNull String name, @NotNull NodeState child) {
        return this.hideChild(name, child) ? EmptyNodeState.MISSING_NODE : this.decorateChild(name, child);
    }

    protected boolean hideProperty(@NotNull String name) {
        return false;
    }

    @NotNull
    protected Iterable<PropertyState> getNewPropertyStates() {
        return Collections.emptyList();
    }

    @Nullable
    protected abstract PropertyState decorateProperty(@NotNull PropertyState var1);

    @Nullable
    private PropertyState decorate(@Nullable PropertyState property) {
        return property == null || this.hideProperty(property.getName()) ? null : this.decorateProperty(property);
    }

    protected static PropertyState fixChildOrderPropertyState(NodeState nodeState, PropertyState propertyState) {
        if (propertyState != null && ":childOrder".equals(propertyState.getName())) {
            ArrayList childNodeNames = new ArrayList();
            nodeState.getChildNodeNames().forEach(childNodeNames::add);
            Iterable values = Iterables.filter(propertyState.getValue(Type.NAMES), x -> childNodeNames.contains(x));
            return PropertyStates.createProperty(":childOrder", (Object)values, Type.NAMES);
        }
        return propertyState;
    }

    @Override
    @NotNull
    public NodeBuilder builder() {
        return new ReadOnlyBuilder(this);
    }

    @Override
    public boolean exists() {
        return this.delegate.exists();
    }

    @Override
    public boolean hasChildNode(@NotNull String name) {
        return this.getChildNode(name).exists();
    }

    @Override
    @NotNull
    public NodeState getChildNode(@NotNull String name) throws IllegalArgumentException {
        return this.decorate(name, this.delegate.getChildNode(name));
    }

    @Override
    @NotNull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        Iterable transformed = Iterables.transform(this.delegate.getChildNodeEntries(), childNodeEntry -> {
            String name;
            NodeState nodeState;
            if (childNodeEntry != null && (nodeState = this.decorate(name = childNodeEntry.getName(), childNodeEntry.getNodeState())).exists()) {
                return new MemoryChildNodeEntry(name, nodeState);
            }
            return null;
        });
        return Iterables.filter((Iterable)transformed, x -> x != null);
    }

    @Override
    @Nullable
    public PropertyState getProperty(@NotNull String name) {
        PropertyState ps = this.decorate(this.delegate.getProperty(name));
        if (ps == null) {
            for (PropertyState p : this.getNewPropertyStates()) {
                if (!name.equals(p.getName())) continue;
                ps = p;
                break;
            }
        }
        return ps;
    }

    @Override
    @NotNull
    public Iterable<? extends PropertyState> getProperties() {
        Iterable propertyStates = Iterables.transform(this.delegate.getProperties(), propertyState -> this.decorate((PropertyState)propertyState));
        return Iterables.filter((Iterable)Iterables.concat((Iterable)propertyStates, this.getNewPropertyStates()), x -> x != null);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof NodeState)) {
            return false;
        }
        if (this.useNativeEquals && this.getClass() == other.getClass()) {
            AbstractDecoratedNodeState o = (AbstractDecoratedNodeState)other;
            return this.delegate.equals(o.delegate);
        }
        return AbstractDecoratedNodeState.equals(this, (NodeState)other);
    }

    @Override
    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        String name;
        DecoratingDiff decoratingDiff = new DecoratingDiff(diff, this);
        if (!AbstractDecoratedNodeState.comparePropertiesAgainstBaseState(this, base, decoratingDiff)) {
            return false;
        }
        HashSet<String> baseChildNodes = new HashSet<String>();
        for (ChildNodeEntry childNodeEntry : base.getChildNodeEntries()) {
            name = childNodeEntry.getName();
            NodeState beforeChild = childNodeEntry.getNodeState();
            NodeState afterChild = this.getChildNode(name);
            if (!afterChild.exists()) {
                if (decoratingDiff.childNodeDeleted(name, beforeChild)) continue;
                return false;
            }
            baseChildNodes.add(name);
            if (afterChild.equals(beforeChild) || decoratingDiff.childNodeChanged(name, beforeChild, afterChild)) continue;
            return false;
        }
        for (ChildNodeEntry childNodeEntry : this.getChildNodeEntries()) {
            name = childNodeEntry.getName();
            if (baseChildNodes.contains(name) || decoratingDiff.childNodeAdded(name, childNodeEntry.getNodeState())) continue;
            return false;
        }
        return true;
    }

    private static class DecoratingDiff
    implements NodeStateDiff {
        private final NodeStateDiff diff;
        private AbstractDecoratedNodeState nodeState;

        private DecoratingDiff(NodeStateDiff diff, AbstractDecoratedNodeState nodeState) {
            this.diff = diff;
            this.nodeState = nodeState;
        }

        @Override
        public boolean childNodeAdded(String name, NodeState after) {
            return this.diff.childNodeAdded(name, this.nodeState.decorate(name, after));
        }

        @Override
        public boolean childNodeChanged(String name, NodeState before, NodeState after) {
            return this.diff.childNodeChanged(name, before, this.nodeState.decorate(name, after));
        }

        @Override
        public boolean childNodeDeleted(String name, NodeState before) {
            return this.diff.childNodeDeleted(name, before);
        }

        @Override
        public boolean propertyAdded(PropertyState after) {
            return this.diff.propertyAdded(this.nodeState.decorate(after));
        }

        @Override
        public boolean propertyChanged(PropertyState before, PropertyState after) {
            return this.diff.propertyChanged(this.nodeState.decorate(before), this.nodeState.decorate(after));
        }

        @Override
        public boolean propertyDeleted(PropertyState before) {
            return this.diff.propertyDeleted(this.nodeState.decorate(before));
        }
    }
}

