/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype.write;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NameMapper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.write.ItemDefinitionTemplate;

class PropertyDefinitionTemplateImpl
extends ItemDefinitionTemplate
implements PropertyDefinitionTemplate {
    private static final String[] ALL_OPERATORS = new String[]{"jcr.operator.equal.to", "jcr.operator.greater.than", "jcr.operator.greater.than.or.equal.to", "jcr.operator.less.than", "jcr.operator.less.than.or.equal.to", "jcr.operator.like", "jcr.operator.not.equal.to"};
    private int requiredType = 1;
    private boolean isMultiple = false;
    private boolean fullTextSearchable = true;
    private boolean queryOrderable = true;
    private String[] queryOperators = ALL_OPERATORS;
    private String[] valueConstraints = null;
    private Value[] defaultValues = null;

    PropertyDefinitionTemplateImpl(NameMapper mapper) {
        super(mapper);
    }

    PropertyDefinitionTemplateImpl(NameMapper mapper, PropertyDefinition definition) throws ConstraintViolationException {
        super(mapper, definition);
        this.setRequiredType(definition.getRequiredType());
        this.setMultiple(definition.isMultiple());
        this.setFullTextSearchable(definition.isFullTextSearchable());
        this.setQueryOrderable(definition.isQueryOrderable());
        this.setAvailableQueryOperators(definition.getAvailableQueryOperators());
        this.setValueConstraints(definition.getValueConstraints());
        this.setDefaultValues(definition.getDefaultValues());
    }

    @Override
    void writeTo(Tree tree) throws RepositoryException {
        super.writeTo(tree);
        tree.setProperty("jcr:requiredType", PropertyType.nameFromValue(this.requiredType).toUpperCase(Locale.ENGLISH));
        tree.setProperty("jcr:multiple", this.isMultiple);
        tree.setProperty("jcr:isFullTextSearchable", this.fullTextSearchable);
        tree.setProperty("jcr:isQueryOrderable", this.queryOrderable);
        tree.setProperty("jcr:availableQueryOperators", Arrays.asList(this.queryOperators), Type.NAMES);
        if (this.valueConstraints != null) {
            tree.setProperty("jcr:valueConstraints", Arrays.asList(this.valueConstraints), Type.STRINGS);
        } else {
            tree.removeProperty("jcr:valueConstraints");
        }
        if (this.defaultValues != null) {
            tree.setProperty(PropertyStates.createProperty("jcr:defaultValues", Arrays.asList(this.defaultValues)));
        } else {
            tree.removeProperty("jcr:defaultValues");
        }
    }

    @Override
    public int getRequiredType() {
        return this.requiredType;
    }

    @Override
    public void setRequiredType(int type) {
        PropertyType.nameFromValue(type);
        this.requiredType = type;
    }

    @Override
    public boolean isMultiple() {
        return this.isMultiple;
    }

    @Override
    public void setMultiple(boolean isMultiple) {
        this.isMultiple = isMultiple;
    }

    @Override
    public boolean isFullTextSearchable() {
        return this.fullTextSearchable;
    }

    @Override
    public void setFullTextSearchable(boolean fullTextSearchable) {
        this.fullTextSearchable = fullTextSearchable;
    }

    @Override
    public boolean isQueryOrderable() {
        return this.queryOrderable;
    }

    @Override
    public void setQueryOrderable(boolean queryOrderable) {
        this.queryOrderable = queryOrderable;
    }

    @Override
    public String[] getAvailableQueryOperators() {
        return this.queryOperators;
    }

    @Override
    public void setAvailableQueryOperators(String[] operators) {
        Objects.requireNonNull(operators);
        this.queryOperators = new String[operators.length];
        System.arraycopy(operators, 0, this.queryOperators, 0, operators.length);
    }

    @Override
    public String[] getValueConstraints() {
        return this.valueConstraints;
    }

    @Override
    public void setValueConstraints(String[] constraints) {
        if (constraints == null) {
            this.valueConstraints = null;
        } else {
            this.valueConstraints = new String[constraints.length];
            System.arraycopy(constraints, 0, this.valueConstraints, 0, constraints.length);
        }
    }

    @Override
    public Value[] getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    public void setDefaultValues(Value[] values) {
        if (values == null) {
            this.defaultValues = null;
        } else {
            this.defaultValues = new Value[values.length];
            System.arraycopy(values, 0, this.defaultValues, 0, values.length);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("- ");
        if (this.getOakName() == null) {
            builder.append("*");
        } else {
            builder.append(this.getOakName());
        }
        if (this.requiredType != 1) {
            builder.append(" (");
            builder.append(Type.fromTag(this.requiredType, false).toString());
            builder.append(")");
        }
        if (this.isAutoCreated()) {
            builder.append(" a");
        }
        if (this.isProtected()) {
            builder.append(" p");
        }
        if (this.isMandatory()) {
            builder.append(" m");
        }
        if (this.getOnParentVersion() != 1) {
            builder.append(" ");
            builder.append(OnParentVersionAction.nameFromValue(this.getOnParentVersion()));
        }
        return builder.toString();
    }
}

