/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.jackrabbit.guava.common.collect.Iterators;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.Filters;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;

public class GlobbingPathFilter
implements EventFilter {
    public static final String STAR = "*";
    public static final String STAR_STAR = "**";
    private final List<String> pattern;
    private final Map<String, Pattern> patternMap;

    private GlobbingPathFilter(@NotNull List<String> pattern, Map<String, Pattern> patternMap) {
        this.pattern = Objects.requireNonNull(pattern);
        this.patternMap = Objects.requireNonNull(patternMap);
    }

    public GlobbingPathFilter(@NotNull String pattern, Map<String, Pattern> patternMap) {
        this.pattern = new ArrayList<String>(10);
        Iterators.addAll(this.pattern, PathUtils.elements(Objects.requireNonNull(pattern)).iterator());
        this.patternMap = Objects.requireNonNull(patternMap);
    }

    public GlobbingPathFilter(@NotNull String pattern) {
        this(pattern, new HashMap<String, Pattern>());
    }

    @Override
    public boolean includeAdd(PropertyState after) {
        return this.includeItem(after.getName());
    }

    @Override
    public boolean includeChange(PropertyState before, PropertyState after) {
        return this.includeItem(after.getName());
    }

    @Override
    public boolean includeDelete(PropertyState before) {
        return this.includeItem(before.getName());
    }

    @Override
    public boolean includeAdd(String name, NodeState after) {
        return this.includeItem(name);
    }

    @Override
    public boolean includeDelete(String name, NodeState before) {
        return this.includeItem(name);
    }

    @Override
    public boolean includeMove(String sourcePath, String name, NodeState moved) {
        return this.includeItem(name);
    }

    @Override
    public boolean includeReorder(String destName, String name, NodeState reordered) {
        return this.includeItem(name);
    }

    private Pattern getPattern(String wildcardStr) {
        Pattern p = this.patternMap.get(wildcardStr);
        if (p == null) {
            p = Pattern.compile("\\Q" + wildcardStr.replace(STAR, "\\E[^/]*\\Q") + "\\E");
            this.patternMap.put(wildcardStr, p);
        }
        return p;
    }

    private boolean wildcardMatch(String pathElement, String wildcardStr) {
        if (STAR_STAR.equals(wildcardStr) || !wildcardStr.contains(STAR)) {
            return pathElement.equals(wildcardStr);
        }
        Pattern regexPattern = this.getPattern(wildcardStr);
        return regexPattern.matcher(pathElement).matches();
    }

    @Override
    public EventFilter create(String name, NodeState before, NodeState after) {
        if (this.pattern.isEmpty()) {
            return null;
        }
        String head = this.pattern.get(0);
        if (this.pattern.size() == 1 && !STAR_STAR.equals(head)) {
            return null;
        }
        if (this.wildcardMatch(name, head)) {
            return new GlobbingPathFilter(this.pattern.subList(1, this.pattern.size()), this.patternMap);
        }
        if (STAR_STAR.equals(head)) {
            if (this.pattern.size() >= 2 && this.wildcardMatch(name, this.pattern.get(1))) {
                return Filters.any(new GlobbingPathFilter(this.pattern.subList(2, this.pattern.size()), this.patternMap), new GlobbingPathFilter(this.pattern, this.patternMap));
            }
            return new GlobbingPathFilter(this.pattern, this.patternMap);
        }
        return null;
    }

    public String toString() {
        return new StringJoiner(", ", GlobbingPathFilter.class.getSimpleName() + "[", "]").add("path=" + String.join((CharSequence)"/", this.pattern)).toString();
    }

    private boolean includeItem(String name) {
        if (!this.pattern.isEmpty() && this.pattern.size() <= 2) {
            String head = this.pattern.get(0);
            if (STAR_STAR.equals(head)) {
                if (this.pattern.size() == 1) {
                    return true;
                }
                return this.wildcardMatch(name, this.pattern.get(1));
            }
            boolean headMatches = this.wildcardMatch(name, head);
            boolean result = this.pattern.size() == 1 ? headMatches : headMatches && STAR_STAR.equals(this.pattern.get(1));
            return result;
        }
        return false;
    }
}

