/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.oak.commons.StringUtils;
import org.apache.jackrabbit.oak.spi.blob.AbstractBlobStore;

public class MemoryBlobStore
extends AbstractBlobStore {
    private HashMap<AbstractBlobStore.BlockId, byte[]> map = new HashMap();
    private HashMap<AbstractBlobStore.BlockId, byte[]> old = new HashMap();
    private HashMap<AbstractBlobStore.BlockId, Long> timestamps = new HashMap();
    private boolean mark;

    @Override
    protected byte[] readBlockFromBackend(AbstractBlobStore.BlockId id) {
        byte[] result = this.map.get(id);
        if (result == null) {
            result = this.old.get(id);
        }
        return result;
    }

    @Override
    protected synchronized void storeBlock(byte[] digest, int level, byte[] data) {
        AbstractBlobStore.BlockId id = new AbstractBlobStore.BlockId(digest, 0L);
        this.map.put(id, data);
        this.timestamps.put(id, System.currentTimeMillis());
    }

    @Override
    public void startMark() throws IOException {
        this.mark = true;
        this.old = this.map;
        this.map = new HashMap();
        this.markInUse();
    }

    @Override
    protected boolean isMarkEnabled() {
        return this.mark;
    }

    @Override
    protected void mark(AbstractBlobStore.BlockId id) {
        byte[] data = this.map.get(id);
        if (data == null && (data = this.old.get(id)) != null) {
            this.map.put(id, data);
        }
    }

    @Override
    public int sweep() {
        int count = this.old.size();
        this.old.clear();
        this.mark = false;
        return count;
    }

    @Override
    public long countDeleteChunks(List<String> chunkIds, long maxLastModifiedTime) throws Exception {
        int count = 0;
        for (String chunkId : chunkIds) {
            AbstractBlobStore.BlockId id = new AbstractBlobStore.BlockId(StringUtils.convertHexToBytes(chunkId), 0L);
            if (this.map.containsKey(id)) {
                if (maxLastModifiedTime != 0L && (maxLastModifiedTime <= 0L || maxLastModifiedTime <= this.timestamps.get(id))) continue;
                this.map.remove(id);
                this.timestamps.remove(id);
                ++count;
                continue;
            }
            if (!this.old.containsKey(id)) continue;
            this.old.remove(id);
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> getAllChunkIds(long maxLastModifiedTime) throws Exception {
        HashMap<AbstractBlobStore.BlockId, byte[]> combinedMap = new HashMap<AbstractBlobStore.BlockId, byte[]>();
        combinedMap.putAll(this.map);
        combinedMap.putAll(this.old);
        final Iterator iter = combinedMap.keySet().iterator();
        return new AbstractIterator<String>(){

            protected String computeNext() {
                AbstractBlobStore.BlockId blockId;
                if (iter.hasNext() && (blockId = (AbstractBlobStore.BlockId)iter.next()) != null) {
                    return StringUtils.convertBytesToHex(blockId.getDigest());
                }
                return (String)this.endOfData();
            }
        };
    }

    @Override
    public void clearCache() {
    }
}

