/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.spi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.caconfig.spi.ConfigurationPersistData;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ConfigurationCollectionPersistData {
    private static final Pattern ITEM_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+$");
    private final Collection<ConfigurationPersistData> items;
    private Map<String, Object> properties;

    public ConfigurationCollectionPersistData(@NotNull Collection<ConfigurationPersistData> items) {
        this.validateItems(items);
        this.items = items;
    }

    private void validateItems(Collection<ConfigurationPersistData> items) {
        HashSet<String> keyNames = new HashSet<String>();
        for (ConfigurationPersistData item : items) {
            if (StringUtils.isBlank(item.getCollectionItemName())) {
                throw new ConfigurationPersistenceException("Collection item name is missing.");
            }
            if (!ITEM_NAME_PATTERN.matcher(item.getCollectionItemName()).matches()) {
                throw new ConfigurationPersistenceException("Invalid collection item name: " + item.getCollectionItemName());
            }
            if (keyNames.contains(item.getCollectionItemName())) {
                throw new ConfigurationPersistenceException("Duplicate collection item name: " + item.getCollectionItemName());
            }
            keyNames.add(item.getCollectionItemName());
        }
    }

    @NotNull
    public Collection<ConfigurationPersistData> getItems() {
        return this.items;
    }

    @Nullable
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public ConfigurationCollectionPersistData properties(Map<String, Object> value) {
        this.properties = value;
        return this;
    }
}

