/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class SitemapUtil {
    private static final String JCR_SYSTEM_PATH = "/jcr:system/";
    private static final String SITEMAP_SELECTOR = "sitemap";
    private static final String SITEMAP_SELECTOR_SUFFIX = "-sitemap";

    private SitemapUtil() {
    }

    @NotNull
    public static Resource getTopLevelSitemapRoot(@NotNull Resource sitemapRoot) {
        Resource topLevelSitemapRoot = sitemapRoot;
        for (Resource parent = sitemapRoot.getParent(); parent != null; parent = parent.getParent()) {
            if (!SitemapUtil.isSitemapRoot(parent)) continue;
            topLevelSitemapRoot = parent;
        }
        return topLevelSitemapRoot;
    }

    @Nullable
    public static Resource normalizeSitemapRoot(@Nullable Resource resource) {
        if (!SitemapUtil.isSitemapRoot(resource)) {
            return null;
        }
        if (resource.getName().equals("jcr:content")) {
            return resource.getParent();
        }
        return resource;
    }

    public static boolean isSitemapRoot(@Nullable Resource resource) {
        if (resource == null) {
            return false;
        }
        Boolean sitemapRoot = (Boolean)((Object)resource.getValueMap().get("sling:sitemapRoot", Boolean.class));
        if (sitemapRoot == null) {
            Resource content = resource.getChild("jcr:content");
            sitemapRoot = content != null ? content.getValueMap().get("sling:sitemapRoot", Boolean.FALSE) : Boolean.FALSE;
        }
        return sitemapRoot;
    }

    public static boolean isTopLevelSitemapRoot(@Nullable Resource resource) {
        return SitemapUtil.isSitemapRoot(resource) && SitemapUtil.getTopLevelSitemapRoot(resource).getPath().equals(resource.getPath());
    }

    @NotNull
    public static String getSitemapSelector(@NotNull Resource sitemapRoot, @NotNull Resource topLevelSitemapRoot, @NotNull String name) {
        String string = name = "<default>".equals(name) ? SITEMAP_SELECTOR : name + SITEMAP_SELECTOR_SUFFIX;
        if (!sitemapRoot.getPath().equals(topLevelSitemapRoot.getPath())) {
            String sitemapRootSubpath = sitemapRoot.getPath().substring(topLevelSitemapRoot.getPath().length() + 1);
            name = sitemapRootSubpath.replace('/', '-') + '-' + name;
        }
        return name;
    }

    @NotNull
    public static Map<Resource, String> resolveSitemapRoots(@NotNull Resource topLevelSitemapRoot, @NotNull String sitemapSelector) {
        List<String> relevantParts;
        if (!SitemapUtil.isTopLevelSitemapRoot(topLevelSitemapRoot)) {
            return Collections.emptyMap();
        }
        if (sitemapSelector.equals(SITEMAP_SELECTOR)) {
            return Collections.singletonMap(topLevelSitemapRoot, "<default>");
        }
        List<String> parts = Arrays.asList(sitemapSelector.split("-"));
        if (parts.size() == 2 && parts.get(0).equals(SITEMAP_SELECTOR) && SitemapUtil.isInteger(parts.get(1))) {
            return Collections.singletonMap(topLevelSitemapRoot, "<default>");
        }
        if (parts.size() > 1 && parts.get(parts.size() - 1).equals(SITEMAP_SELECTOR)) {
            relevantParts = parts.subList(0, parts.size() - 1);
        } else if (parts.size() > 2 && parts.get(parts.size() - 2).equals(SITEMAP_SELECTOR) && SitemapUtil.isInteger(parts.get(parts.size() - 1))) {
            relevantParts = parts.subList(0, parts.size() - 2);
        } else {
            return Collections.emptyMap();
        }
        LinkedHashMap<Resource, String> roots = new LinkedHashMap<Resource, String>();
        SitemapUtil.resolveSitemapRoots(topLevelSitemapRoot, relevantParts, roots);
        return roots;
    }

    @NotNull
    public static Iterator<Resource> findSitemapRoots(final ResourceResolver resolver, String searchPath) {
        final String correctedSearchPath = searchPath == null ? "/" : searchPath;
        final StringBuilder query = new StringBuilder(correctedSearchPath.length() + 35);
        query.append("/jcr:root").append(ISO9075.encodePath(correctedSearchPath));
        if (!correctedSearchPath.endsWith("/")) {
            query.append('/');
        }
        query.append("/*[@").append("sling:sitemapRoot").append('=').append(Boolean.TRUE).append(']');
        query.append(" option(index tag slingSitemaps)");
        return new Iterator<Resource>(){
            private final Iterator<Resource> hits;
            private Resource next;
            {
                this.hits = resolver.findResources(query.toString(), "xpath");
                this.next = this.seek();
            }

            private Resource seek() {
                while (this.hits.hasNext()) {
                    Resource nextHit = SitemapUtil.normalizeSitemapRoot(this.hits.next());
                    if (nextHit == null || nextHit.getPath().equals(correctedSearchPath) || nextHit.getPath().startsWith(SitemapUtil.JCR_SYSTEM_PATH)) continue;
                    return nextHit;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Resource next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Resource ret = this.next;
                this.next = this.seek();
                return ret;
            }
        };
    }

    private static boolean isInteger(String text) {
        try {
            Integer.parseUnsignedInt(text);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static void resolveSitemapRoots(@NotNull Resource sitemapRoot, @NotNull List<String> parts, @NotNull Map<Resource, String> result) {
        if (SitemapUtil.isSitemapRoot(sitemapRoot)) {
            result.put(sitemapRoot, String.join((CharSequence)"-", parts));
        }
        for (int i = 0; i < parts.size(); ++i) {
            int j = i + 1;
            String childName = String.join((CharSequence)"-", parts.subList(0, j));
            Resource namedChild = sitemapRoot.getChild(childName);
            if (namedChild == null) continue;
            if (j == parts.size() && SitemapUtil.isSitemapRoot(namedChild)) {
                result.put(namedChild, "<default>");
                continue;
            }
            if (parts.size() <= j) continue;
            SitemapUtil.resolveSitemapRoots(namedChild, parts.subList(j, parts.size()), result);
        }
    }
}

