/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.apple;

import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.PropertyListFormatException;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.util.IOUtils;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.IOExceptionWithCause;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.xml.sax.SAXException;

public class BPListDetector
implements Detector {
    static MediaType MEMGRAPH = MediaType.application("x-plist-memgraph");
    static MediaType WEBARCHIVE = MediaType.application("x-plist-webarchive");
    static MediaType PLIST = MediaType.application("x-plist");
    static MediaType ITUNES = MediaType.application("x-plist-itunes");
    static MediaType BMEMGRAPH = MediaType.application("x-bplist-memgraph");
    static MediaType BWEBARCHIVE = MediaType.application("x-bplist-webarchive");
    static MediaType BPLIST = MediaType.application("x-bplist");
    static MediaType BITUNES = MediaType.application("x-bplist-itunes");
    private static Map<MediaType, MediaType> BINARY_TO_XML = new HashMap<MediaType, MediaType>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        if (input == null) {
            return MediaType.OCTET_STREAM;
        }
        input.mark(8);
        byte[] bytes = new byte[8];
        try {
            int read = IOUtils.readFully(input, bytes);
            if (read < 6) {
                MediaType mediaType = MediaType.OCTET_STREAM;
                return mediaType;
            }
        }
        catch (IOException e) {
            MediaType mediaType = MediaType.OCTET_STREAM;
            return mediaType;
        }
        finally {
            input.reset();
        }
        int i = 0;
        if (bytes[i++] != 98 || bytes[i++] != 112 || bytes[i++] != 108 || bytes[i++] != 105 || bytes[i++] != 115 || bytes[i++] != 116) {
            return MediaType.OCTET_STREAM;
        }
        NSObject rootObj = null;
        try {
            rootObj = input instanceof TikaInputStream && ((TikaInputStream)input).hasFile() ? PropertyListParser.parse((File)((TikaInputStream)input).getFile()) : PropertyListParser.parse((InputStream)input);
            if (input instanceof TikaInputStream) {
                ((TikaInputStream)input).setOpenContainer(rootObj);
            }
        }
        catch (PropertyListFormatException | ParseException | ParserConfigurationException | SAXException e) {
            throw new IOExceptionWithCause("problem parsing root", e);
        }
        if (rootObj instanceof NSDictionary) {
            return BPListDetector.detectOnKeys(((NSDictionary)rootObj).getHashMap().keySet());
        }
        return BPLIST;
    }

    static MediaType detectOnKeys(Set<String> keySet) {
        if (keySet.contains("nodes") && keySet.contains("edges") && keySet.contains("graphEncodingVersion")) {
            return BMEMGRAPH;
        }
        if (keySet.contains("WebMainResource")) {
            return BWEBARCHIVE;
        }
        if (keySet.contains("Playlists") && keySet.contains("Tracks") && keySet.contains("Music Folder")) {
            return BITUNES;
        }
        return BPLIST;
    }

    static MediaType detectXMLOnKeys(Set<String> keySet) {
        return BINARY_TO_XML.get(BPListDetector.detectOnKeys(keySet));
    }

    static {
        BINARY_TO_XML.put(BMEMGRAPH, MEMGRAPH);
        BINARY_TO_XML.put(BWEBARCHIVE, WEBARCHIVE);
        BINARY_TO_XML.put(BPLIST, PLIST);
        BINARY_TO_XML.put(BITUNES, ITUNES);
    }
}

