/*
 *
 *	File: PlainReader.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 * 
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.fontengine.font.postscript;

import java.io.IOException;
import com.adobe.fontengine.font.FontInputStream;

import com.adobe.fontengine.font.InvalidFontException;

/**
 * A no-op filter to read the unencrypted portions of a type1 font.
 *
 * <h4>Synchronization</h4>
 * 
 * This class is NOT threadsafe. Multiple instances can safely
 * coexist without threadsafety issues, but each must only be accessed 
 * from one thread (or must be guarded by the client).
 */
final class PlainReader implements Reader {
    int lastRead;
    
    public int read(FontInputStream stream)
    	throws IOException, InvalidFontException
    {
        lastRead = stream.read();
        if (lastRead == -1)
        	throw new InvalidFontException("unexpected end of file");
        return lastRead;
    }
    
    public void unreadLast(FontInputStream stream)
    	throws IOException
    {
        stream.unread(lastRead);
    }
}