/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.activitystreams;

import org.osgi.annotation.versioning.ProviderType;

/**
 * Defines constants for activity events.
 * @since 0.0.10
 */
@ProviderType
public interface ActivityEventConstants {

    /**
     * The topic for the OSGi event which is sent when an activity has been added to a stream.
     */
    public static final String TOPIC_ACTIVITY_ADDED = "com/adobe/granite/activitystreams/activity/ADDED";

    /**
     * The name of the event property holding the activity id
     */
    public static final String PROPERTY_ID = "id";

    /**
     * The name of the event property holding the activity path
     */
    public static final String PROPERTY_PATH = "path";

}