/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.haf.converter.api;

import java.util.List;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

import com.adobe.granite.haf.api.OrderByDetails;
import org.osgi.annotation.versioning.ProviderType;

/**
 * Interface for a hypermedia converter that can render a Resource with paginated entities into a particular hypermedia
 * type.
 */
@ProviderType
public interface PaginatableHypermediaConverter extends HypermediaConverter {
    /**
     * Gets the pagination start value from the request. This can then be injected into methods to allow them to
     * correctly respond to paginated requests.
     * @param request current HTTP request
     * @return a string is the value of the pagination startparameter
     */
    @CheckForNull
    String getPaginationStartValue(HttpServletRequest request);

    /**
     * Gets the pagination limit value from the request. This can then be injected into methods to allow them to
     * correctly respond to paginated requests.
     * @param request current HTTP request
     * @return a string is the value of the pagination limit parameter or -1 if the limit is not specified
     */
    int getPaginationLimitValue(HttpServletRequest request);

    /**
     * Get the order by details from the request.  This can then be injected into methods to allow them to correctly.
     * respond.
     * @param request current HTTP request.
     * @return A List of OrderByDetails.
     */
    @Nonnull
    List<OrderByDetails> getOrderBy(HttpServletRequest request);
}
