/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2012 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/
package com.adobe.granite.keystore;

/**
 * The {@code KeyStoreNotInitialisedException} is thrown by the methods from the {@link com.adobe.granite.keystore.KeyStoreService} that
 * access a key store / trust store before the store is actually initialised.
 */
public class KeyStoreNotInitialisedException extends RuntimeException {

    public KeyStoreNotInitialisedException(String message) {
        super(message);
    }

    public KeyStoreNotInitialisedException(String message, Throwable cause) {
        super(message, cause);
    }

    public KeyStoreNotInitialisedException(Throwable cause) {
        super(cause);
    }
}
