/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2001-2002, Adobe Systems Incorporated                        */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/
package com.adobe.versioncue.nativecomm;

/**
 * This class represents a NativeCommException thrown in the native dll during
 * execution of a request.
 * 
 * @author <a href="mailto:tnaroska@adobe.com">Timo Naroska</a>
 * @version $Revision: #1 $
 */
public class ServiceCallException extends NativeCommException
{
	// --------------------------------------------------------------------------- Private Variables

	/**  UID */
	private static final long serialVersionUID = -8786278664104163865L;

	/** Failed NativeService call */
	private final String call;

	/** Reason code */
	private final String reason;

	/** detail message */
	private final String errorMessage;

	// -------------------------------------------------------------------------- Public Constructor

	/**
	 * Constructor for ServiceException.
	 * 
	 * @param call NativeService call
	 * @param reason reasonCode
	 * @param message detail message
	 */
	public ServiceCallException(String call, String reason, String message)
	{
		super(description(call, reason, message));

		this.call = call;
		this.reason = reason;
		this.errorMessage = message;
	}

	// ------------------------------------------------------------------------------ Public Methods

	/**
	 * Failed service call
	 * 
	 * @return service call
	 */
	public String call()
	{
		return call;
	}

	/**
	 * Reason code
	 * 
	 * @return reason code string constant
	 */
	public String reasonCode()
	{
		return reason;
	}

	/**
	 * Detail Message
	 * 
	 * @return detail message
	 */
	public String message()
	{
		return errorMessage;
	}

	// ----------------------------------------------------------------------- Private Class Methods

	/**
	 * @param call NativeService call
	 * @param reason reasonCode
	 * @param message detail message
	 * @return formatted error message
	 */
	private static String description(String call, String reason, String message)
	{
		return '\'' + call + "' failed <" + reason + ">: " + message;
	}
}