package com.adobe.xfa.text;

import com.adobe.xfa.gfx.GFXDriver;
import com.adobe.xfa.gfx.GFXEnv;
import com.adobe.xfa.gfx.GFXGlyphOrientation;
import com.adobe.xfa.ut.CoordPair;
import com.adobe.xfa.ut.Rect;
import com.adobe.xfa.ut.UnitSpan;

/**
 * @exclude from published api.
 */

class DrawParm {
	private final TextDrawInfo moDrawInfo;
	private GFXDriver mpoDriver;

	private Rect moInvalid;
	private float moInvalidAMin;
	private float moInvalidAMax;
	private UnitSpan moInvalidBMin;
	private UnitSpan moInvalidBMax;

	private Rect mpoTruncate;
	private float moTruncateAMin;
	private float moTruncateAMax;
	private UnitSpan moTruncateBMin;
	private UnitSpan moTruncateBMax;

	private UnitSpan moOffsetText;
	private UnitSpan moOffsetVertText;	// TODO: this is not retrieved in the C++ implementation

	private UnitSpan moShiftSize;

	private int mpnCharIndex = -1;

//	private TextPrefOpt.enumPref meOpt;

	public DrawParm (TextDrawInfo oDrawInfo) {
		moDrawInfo = oDrawInfo;
	}

	public TextDrawInfo drawInfo () {
		return moDrawInfo;
	}

	GFXEnv env () {
		return moDrawInfo.getGfxEnv();
	}

	GFXDriver driver () {
		return mpoDriver;
	}

	void setDriver (GFXDriver poDriver) {
		mpoDriver = poDriver;
	}

	Rect invalid () {
		return moInvalid;
	}

	void setInvalid (Rect oInvalid) {
		moInvalid = oInvalid;
		setInvalidExtents (oInvalid);
	}

	float invalidAMin () {
		return moInvalidAMin;
	}

	float invalidAMax () {
		return moInvalidAMax;
	}

	UnitSpan invalidBMin () {
		return moInvalidBMin;
	}

	UnitSpan invalidBMax () {
		return moInvalidBMax;
	}

	Rect truncate () {
		return mpoTruncate;
	}

	void setTruncate (Rect poTruncate) {
		mpoTruncate = poTruncate;
		if (poTruncate != null) {
			setTruncateExtents (poTruncate);
		}
	}

	float truncateAMin () {
		return moTruncateAMin;
	}

	float truncateAMax () {
		return moTruncateAMax;
	}

	UnitSpan truncateBMin () {
		return moTruncateBMin;
	}

	UnitSpan truncateBMax () {
		return moTruncateBMax;
	}

	void translate (CoordPair oXYOrigin, int eOrientation) {
		setInvalidExtents (ABXY.toAB (oXYOrigin, moInvalid, eOrientation));
		if (mpoTruncate != null) {
			setTruncateExtents (ABXY.toAB (oXYOrigin, mpoTruncate, eOrientation));
		}
	}

	void setDispHeight (LineHeight oDispHeight) {
		moOffsetText = Units.toUnitSpan (oDispHeight.textOffset (GFXGlyphOrientation.HORIZONTAL));
		moOffsetVertText = Units.toUnitSpan (oDispHeight.textOffset (GFXGlyphOrientation.VERTICAL));
		moShiftSize = Units.toUnitSpan (oDispHeight.size());
	}

	UnitSpan offsetText () {
		return moOffsetText;
	}

	UnitSpan offsetVertText () {
		return moOffsetVertText;			// TODO: this method has no implementation in C++
	}

	UnitSpan shiftSize () {
		return moShiftSize;
	}

	public Rect page () {
		return moDrawInfo.getPage();
	}

	public TextSelection primary () {
		return moDrawInfo.getPrimary();
	}

	public TextSelection secondary () {
		return moDrawInfo.getSecondary();
	}

	public int charIndex () {
		return mpnCharIndex;
	}

	public void setCharIndex (int pnCharIndex) {
		mpnCharIndex = pnCharIndex;
	}

//	int opt () {
//		return meOpt;
//	}

//	void setOpt (TextPrefOpt.enumPref eOpt) {
//		meOpt = eOpt;
//	}

	private void setInvalidExtents (Rect oInvalid) {
		moInvalidAMin = Units.toFloat (oInvalid.left());
		moInvalidAMax = Units.toFloat (oInvalid.right());
		moInvalidBMin = oInvalid.top();
		moInvalidBMax = oInvalid.bottom();
	}

	private void setTruncateExtents (Rect poTruncate) {
		if (poTruncate != null) {
			moTruncateAMin = Units.toFloat (poTruncate.left());
			moTruncateAMax = Units.toFloat (poTruncate.right());
			moTruncateBMin = poTruncate.top();
			moTruncateBMax = poTruncate.bottom();
		}
	}
}
