/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.ut;

/**
 * A mutable holder class to represent a <i>boolean</i> value.
 * BooleanHolder objects are useful as out and inout parameters.
 */
public final class BooleanHolder {

	/**
	 * Instantiates an BooleanHolder object with the initial value false.
	 */
	public BooleanHolder() {
	}
	
	/**
	 * Instantiates an BooleanHolder object with the initial value given.
	 *
	 * @param value the initial value.
	 */
	public BooleanHolder(boolean value) {
		this.value = value;
	}
	
	/**
	 * The boolean value held by this object.
	 */
	public boolean value;

}
