/*
 * Copyright 1997-2011 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.commons.jcr;

import org.apache.jackrabbit.api.observation.JackrabbitEvent;

import javax.jcr.observation.Event;

/**
 * Utility for common JCR Observations
 */
public class ObservationUtil {

    /**
     * On a JCR implementation which supports cluster-aware event processing, checks if the event has originally
     * happened locally (internal) or remotely (external).
     *
     * <p>
     * If the result of this method call is used to filter out external events, the recommended approach is to use one
     * of the following dedicated APIs:
     *
     * <ol>
     * <li>Register observation listeners with a <pre>org.apache.jackrabbit.api.observation.JackrabbitEventFilter</pre>
     * and specify <pre>setNoExternal(true)</pre></li>
     * <li>Implement the <pre>org.apache.jackrabbit.oak.plugins.observation.ExcludeExternal</pre> marker interface (
     * Oak-only )</li>
     * </ol>
     *
     * This ensures that external events are not delivered within the cluster only to be filtered away by the receiving
     * listener.
     * <p>
     * 
     * @param event The event to be checked.
     * @return <code>true</code> if the JCR implementation is cluster aware and the event is external.
     */
    public static boolean isExternal(Event event) {
        return (event instanceof JackrabbitEvent) && ((JackrabbitEvent) event).isExternal();
    }

}
