package com.day.cq.dam.commons.util;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public class S7TemplateHelper {

    private static final String DAM_S7DAM_TYPE = "dam:s7damType";
    private static final String DM_TEMPLATE = "DMTemplate";

    public static boolean isS7Template (Resource resource) {
        Resource contentResource = resource.getChild("jcr:content");
        if (contentResource != null) {
            ValueMap vm = contentResource.adaptTo(ValueMap.class);
            String s7Type = vm.get(DAM_S7DAM_TYPE, "");
            if (DM_TEMPLATE.equals(s7Type)) {
                return true;
            }
        }

        return false;
    }
}
