/*
 * ADOBE CONFIDENTIAL
 *   ___________________
 *
 *    Copyright 2012 Adobe Systems Incorporated
 *    All Rights Reserved.
 *
 *   NOTICE:  All information contained herein is, and remains
 *   the property of Adobe Systems Incorporated and its suppliers,
 *   if any.  The intellectual and technical concepts contained
 *   herein are proprietary to Adobe Systems Incorporated and its
 *   suppliers and are protected by trade secret or copyright law.
 *   Dissemination of this information or reproduction of this material
 *   is strictly forbidden unless prior written permission is obtained
 *   from Adobe Systems Incorporated.
 */

package com.day.cq.mailer;

import org.apache.jackrabbit.api.security.user.Authorizable;

import javax.jcr.RepositoryException;
import java.util.Iterator;

/**
 * Interface to mark a set of {@link org.apache.jackrabbit.api.security.user.Authorizable} dedicated to
 * receive a Mailing.
 * This is more relaxed than to require a {@link org.apache.jackrabbit.api.security.user.Group Group}
 *
 * @see com.day.cq.mailer.MailingService
 *
 */
public interface AuthorizableMailingList {

    /**
     * The members of this List
     * @return the {@link org.apache.jackrabbit.api.security.user.Authorizable Authorizables} that
     * are part of this List.
     *
     * @throws javax.jcr.RepositoryException in case of error
     */
    Iterator<Authorizable> members() throws RepositoryException;
}
