/*
 * Copyright 1997-2010 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.mailer;

/**
 * MessageGateway is an Object capable of sending a message to a recipient.
 * An example of an message would be an {@link org.apache.commons.mail.Email Email} .
 * This is an ServiceProvider to be used as to register as an OSGI service.
 * Gateways can be accessed via {@link com.day.cq.mailer.MessageGatewayService MessageGatewayService}.
 * This is used for example by the MailingService to send messages over different
 * Gateways
 *
 * @see MessageGatewayService
 * @since 5.4
 */
public interface MessageGateway<Type> {

    /**
     * Indicate if the Gateway accepts a Message of the given type
     * @param type to test
     * @return true if the Class is of {@link Type}.
     */
    boolean handles(Class<? extends Type> type);

    /**
     * @param message to send
     * @throws MailingException in case the message can not be sent.
     */
    void send(Type message) throws MailingException;
}