/*
 * ***********************************************************************
 *
 *  ADOBE CONFIDENTIAL
 *  ___________________
 *
 *   Copyright 2012 Adobe Systems Incorporated
 *   All Rights Reserved.
 *
 *  NOTICE:  All information contained herein is, and remains
 *  the property of Adobe Systems Incorporated and its suppliers,
 *  if any.  The intellectual and technical concepts contained
 *  herein are proprietary to Adobe Systems Incorporated and its
 *  suppliers and are protected by trade secret or copyright law.
 *  Dissemination of this information or reproduction of this material
 *  is strictly forbidden unless prior written permission is obtained
 *  from Adobe Systems Incorporated.
 * ************************************************************************
 */

package com.day.cq.mcm.emailprovider.types;

/**
 * This interface manages the connection parameters for an email provider.
 * The getter and setter methods for connection identifier id (username/identifier) are inherited from BaseType
 */
public interface ConnectionParams extends BaseType {
    /**
     * Get the key for connection (this would be password or any access key)
     * @return The key (password or access key) for connection.
     */
    public String getKey();

    /**
     * Set the key (this would be password or any access key) for connection parameters
     * @param key The key which could be password or access key etc.
     */
    public void setKey(String key);

    /**
     * Get the connection URL. This URL would be used to connect to the email provider.
     * @return The URL to be used to connect to the email provider.
     */
    public String getUrl();

    /**
     * Set the connection URL. This URL would be used to connect to the email provider.
     * @param url The URL to be used to connect to the email provider.
     */
    public void setUrl(String url);

    /**
     * This can be used to get the account ID associated with the connection.
     * @return account identifier.
     */
    public String getAccountId();

    /**
     * This can be used to set the account identifier associated with the connection.
     * Many email providers support multiple accounts associated with a single client. This parameter
     * can be used to identify such accounts. 
     * @param accountId The account ID to be used with connection.
     */
    public void setAccountId(String accountId);

    /**
     * Get the name of the email provider. This name will be used to identify an email provider implementation.
     * @return The name of the email provider.
     */
    public String getProviderName();

    /**
     * Get the name of the email provider. This name will be used to identify an email provider implementation.
     * @param providerName The name of the email provider.
     */
    public void setProviderName(String providerName);
}
