/*************************************************************************
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 * Copyright 2011 Adobe
 * All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 **************************************************************************/

package com.day.cq.replication;

import java.util.Collection;

/**
 * <code>ListenerLogDelegator</code> implements a replication log that also
 * sends the messages to the listener
 */
public class ListenerLogDelegator implements ReplicationLog {

    private final ReplicationLog log;

    private final ReplicationListener listener;

    public ListenerLogDelegator(ReplicationLog log, ReplicationListener listener) {
        this.log = log;
        this.listener = listener == null ? ReplicationListener.NOP : listener;
    }

    public Level getLevel() {
        return log.getLevel();
    }

    public void setLevel(Level level) {
        log.setLevel(level);
    }

    public Collection<String> getLines() {
        return log.getLines();
    }

    public void debug(String message) {
        listener.onMessage(Level.DEBUG, message);
        log.debug(message);
    }

    public void debug(String fmt, Object... args) {
        debug(String.format(fmt, args));
    }

    public void info(String message) {
        listener.onMessage(Level.INFO, message);
        log.info(message);
    }

    public void info(String fmt, Object... args) {
        info(String.format(fmt, args));
    }

    public void warn(String message) {
        listener.onMessage(Level.WARN, message);
        log.warn(message);
    }

    public void warn(String fmt, Object... args) {
        warn(String.format(fmt, args));
    }

    public void error(String message) {
        listener.onMessage(Level.ERROR, message);
        log.error(message);
    }

    public void error(String fmt, Object... args) {
        error(String.format(fmt, args));
    }
}